package com.bxm.mccms.common.model.income;

import java.math.BigDecimal;
import java.util.Date;

import com.bxm.mccms.common.model.base.BaseEntity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位渠道收益记录导入的Excel对象
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-01-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionChannelIncomeExcelDTO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 日期
     */
    @Excel(name = "日期")
    private Date datetime;

    /**
     * 广告位ID
     */
    @Excel(name = "广告位ID")
    private String positionId;

    /**
     * 渠道
     */
    @Excel(name = "渠道")
    private String sdkChannelType;

    /**
     * 总曝光
     */
    @Excel(name = "总曝光")
    private Long totalOpen;

    /**
     * 总点击
     */
    @Excel(name = "总点击")
    private Long totalClick;

    /**
     * 总收益
     */
    @Excel(name = "总收益")
    private BigDecimal totalIncome;

    /**
     * 分成比例
     */
    @Excel(name = "分成比例", replace = {"%_"})
    private BigDecimal divideInto;

}
