package com.bxm.mccms.common.model.income;

import java.io.Serializable;
import java.math.BigDecimal;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;

/**
 * 广告位渠道收益记录分页查询结果对象</h3>
 *
 * @author zhengwangeng
 * @since 2021-01-15
 */
@Data
public class PositionChannelIncomeListVO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 日期
     */
    private String datetime;

    /**
     * 开发者id
     */
    private Long developerId;
    private String developerName;

    /**
     * 应用ID
     */
    private Long appId;
    private String appName;

    /**
     * 广告位Id
     */
    private String positionId;
    private String positionName;

    /**
     * 总曝光量
     */
    private Long totalOpen;

    /**
     * 总点击量
     */
    private Long totalClick;

    /**
     * 总收益
     */
    private BigDecimal totalIncome;

    /**
     * 分成比率
     */
    private BigDecimal divideInto;

    /**
     * 公司收益
     */
    private BigDecimal bxmIncome;

    /**
     * 开发者收益
     */
    private BigDecimal developerIncome;
}
