package com.bxm.mccms.common.model.income;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotBlank;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;

/**
 * 广告位渠道收益同步渠道的数据对象</h3>
 *
 * @author zhengwangeng
 * @since 2021-01-18
 */
@Data
public class PositionChannelIncomeSyncDTO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    //广点通后台
    public static final String GDT_CHANNEL = "gdt_channel";

    //互动后台
    public static final String INTERACT_CHANNEL = "interact_channel";

    /**
     * 可同步的渠道
     */
    @NotBlank(message = "可同步的渠道不能为空！")
    private String channel;

    /**
     * 开始日期
     */
    @NotBlank(message = "开始日期不能为空！")
    private String startTime;

    /**
     * 结束日期
     */
    @NotBlank(message = "结束日期不能为空！")
    private String endTime;

    /**
     * 分成比率
     */
    //@Range(min = 0, max = 100, message = "分成比率只能是0-100之间的数字")
    private BigDecimal divideInto;

    /**
     * 广告位ID
     */
    private String positionId;
}
