package com.bxm.mccms.common.model.income;

import java.math.BigDecimal;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位渠道收益记录
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-01-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionChannelIncomeUpdateDTO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @NotNull(message = "ID不能为空！")
    private Long id;

    /**
     * 总曝光
     */
    @NotNull(message = "总曝光不能为空！")
    @Min(value = 0, message = "总曝光不能为负数！")
    private Long totalOpen;

    /**
     * 总点击
     */
    @NotNull(message = "总点击不能为空！")
    @Min(value = 0, message = "总点击不能为负数！")
    private Long totalClick;

    /**
     * 总收益
     */
    @NotNull(message = "总收益不能为空！")
    @Min(value = 0, message = "总收益不能为负数！")
    private BigDecimal totalIncome;

    /**
     * 媒体收益
     */
    @NotNull(message = "媒体收益不能为空！")
    @Min(value = 0, message = "媒体收益不能为负数！")
    private BigDecimal developerIncome;


}
