package com.bxm.mccms.common.model.income;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import com.bxm.mccms.common.model.PageDTO;

import lombok.Data;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 19:32
 */
@Data
public class PositionIncomeDTO extends PageDTO implements Serializable {
    private static final long serialVersionUID = -8495050485906100143L;

    private Long id;

    /**
     * 日期
     */
    private String datetime;
    private String mj;

    /**
     * 业务类型
     */
    private Integer businessType;

    private Integer status;

    /**
     * 广告位id
     */
    private String positionId;
    /**
     * 结算方式
     */
    private Integer settleType;
    /**
     * 公司预估收益
     */
    private BigDecimal bxmPreIncome;

    /**
     * 开发者预估收益
     */
    private BigDecimal positionPreIncome;
    /**
     * 上游平台消耗
     */
    private BigDecimal totalIncome;

    /**
     *  广告位对接方式 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;
    /**
     * dsp类型：1 标准广告，2 组件，3 互动
     */
    private Integer dspType;

    private List<Long> developerIdList;

    /**
     * 总请求量
     */
    private Long totalSend;

    /**
     * 总曝光量
     */
    private Long totalOpen;

    /**
     * 总点击量
     */
    private Long totalClick;
}
