package com.bxm.mccms.common.model.income;

import java.io.Serializable;
import java.util.List;

import com.bxm.mccms.common.model.PageDTO;

import lombok.Data;

/**
 * 广告位收入分页查询对象</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 19:32
 */
@Data
public class PositionIncomeQueryDTO extends PageDTO implements Serializable {

    private static final long serialVersionUID = -8495050485906100143L;

    /**
     * 日期
     */
    private String datetime;

    /**
     * 媒介code
     */
    private String mj;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 结算方式
     */
    private Integer settleType;

    /**
     *  广告位对接方式 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;

    /**
     * dsp类型：1 标准广告，2 组件，3 互动
     */
    private Integer dspType;

    /**
     * 广告位场景：详情请看枚举
     */
    private Integer positionScene;

    /**
     * 广告位类型（这个是客户化类型）：1 标准广告，2 非标准广告
     */
    private Integer customPositionType;

    /**
     * 开发者ID,名称，AppKey
     */
    private String developerKeyword;

    /**
     * 应用ID,名称
     */
    private String appKeyword;

    /**
     * 广告位ID,名称
     */
    private String positionKeyword;

    /**
     * 需要查询的广告位ID列表
     */
    private List<String> positionIdList;
}
