package com.bxm.mccms.common.model.income;

import java.math.BigDecimal;

import org.apache.commons.lang.StringUtils;

import com.bxm.mccms.common.core.entity.PositionIncome;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 16:50
 */
@Data
public class PositionIncomeVO {

    private static final long serialVersionUID = -6439393345213508074L;
    private Long id;

    /**
     * 日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private String datetime;
    private String mj;
    private String developerName;
    private String appName;
    private String positionName;

    /**
     * 总请求量
     */
    private Long totalSend;

    /**
     * 总曝光量
     */
    private Long totalOpen;

    /**
     * 总点击量
     */
    private Long totalClick;
    /**
     * 上游平台消耗
     */
    private BigDecimal totalIncome;
    /**
     * 公司预估收益
     */
    private BigDecimal bxmPreIncome;

    /**
     * 开发者预估收益
     */
    private BigDecimal positionPreIncome;
    /**
     * 状态：0未提交，1已经提交，2已经确认，
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 修改日志id
     */
    private Long modifyLogId;

    /**
     * 上游DSP
     */
    private String dsp;

    /**
     * 上游结算方式  合作类型： 1 分成，2 竞价，3 合约  默认为 2
     */
    private Integer preSettleType = 2;


    /**
     * 下游结算方式
     */
    private Integer settleType;
    private String settleConfig;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     *  广告位对接方式 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;

    /**
     * dsp类型：1 标准广告，2 组件，3 互动
     */
    private Integer dspType;

    /**
     * 广告位场景：详情请看枚举
     */
    private Integer positionScene;

    /**
     * 广告位类型（这个是客户化类型）：1 标准广告，2 非标准广告
     */
    private String customPositionType;

    private String sdkChannelType = "bxm_channel";

    public String getCustomPositionType() {
        if (positionScene != null) {
            PositionSceneTypeEnum positionSceneTypeEnum = PositionSceneTypeEnum.get(positionScene);
            if (positionSceneTypeEnum != null) {
                return positionSceneTypeEnum.getCustomPositionTypeEnum().getName();
            }
        }
        return StringUtils.EMPTY;
    }

    public static PositionIncomeVO of(PositionIncome income){
        PositionIncomeVO vo = new PositionIncomeVO();
        vo.setId(income.getId());
        vo.setDatetime(income.getDatetime());

        return vo;

    }
}
