package com.bxm.mccms.common.model.income;

import java.math.BigDecimal;

import com.bxm.mccms.common.model.base.BaseEntity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 收款
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-07-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ReceiptExcelDTO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 公司名称
     */
    @Excel(name = "公司主体")
    private String companyName;

    /**
     * 公司类型
     */
    @Excel(name = "公司类型")
    private String companyType;

    /**
     * 业务名称
     */
    @Excel(name = "业务")
    private String business;

    /**
     * 财务类型
     */
    @Excel(name = "财务类型")
    private String financialType;

    /**
     * 开票类型
     */
    @Excel(name = "开票类型")
    private String invoiceType;

    /**
     * 月份
     */
    @Excel(name = "月份")
    private String month;

    /**
     * 变现猫预估收益
     */
    @Excel(name = "变现猫预估收益")
    private BigDecimal bxmPreIncome;

}
