package com.bxm.mccms.common.model.income.datagrab;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 腾讯-优量汇数据对象。</br>
 * Created by zhengwangeng on 2020/8/7 15:42.
 */
@Data
public class AdnetIncome implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<Entitie> list;

    private Conf conf;

    @Data
    public static class Entitie implements Serializable {

        private static final long serialVersionUID = 1L;

        private int member_id;
        private String report_day;
        private int media_id;
        private String medium_name;
        private String placement_type;
        private int app_id;
        private String placement_id;
        private String placement_name;
        private double revenue;
        private double ecpm;
        private int request_count;
        private int return_count;
        private int ad_request_count;
        private int ad_return_count;
        private int pv;
        private int click;
        private double fill_rate;
        private double exposure_rate;
        private double click_rate;
        private double ad_fill_rate;
        private double ad_exposure_rate;
        private double cpc;
        private int base_revenue;
        private int encourage_revenue;

    }

    @Data
    public static class Conf implements Serializable {
        private int page;
        private int per_page;
        private int total_page;
        private int total_number;
    }
}
