package com.bxm.mccms.common.model.income.datagrab;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 腾讯-优量汇数据对象。</br>
 * Created by zhengwangeng on 2020/8/7 15:42.
 */
@Data
public class OceanengineIncome implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * CompareDataList : []
     * CompareSummary : {}
     * DataList : []
     * ExtraField : null
     * Pagination : {}
     * Summary : {}
     */

    private CompareSummaryBean CompareSummary;
    private Object ExtraField;
    private PaginationBean Pagination;
    private SummaryBean Summary;
    private List<?> CompareDataList;
    private List<Entitie> DataList;

    @Data
    public static class CompareSummaryBean {
    }

    @Data
    public static class PaginationBean {
        /**
         * Current : 1
         * PageSize : 30
         * Total : 1
         */

        private int Current;
        private int PageSize;
        private int Total;
    }

    @Data
    public static class SummaryBean {

        /**
         * Click : 0
         * Cpm : 30
         * Ctr : 0
         * Currency : cny
         * EndDate : 2020-08-06
         * Impression : 1
         * Income : 0.03
         * StartDate : 2020-07-31
         */

        private int Click;
        private int Cpm;
        private int Ctr;
        private String Currency;
        private String EndDate;
        private int Impression;
        private double Income;
        private String StartDate;


    }

    @Data
    public static class Entitie {

        /**
         * AccessMethod : 2
         * AppCodeType : 3
         * Click : 0
         * CodeId : 887294782
         * CodeName : 开屏
         * Cpm : 30
         * Ctr : 0
         * Currency : cny
         * EndDate : 2020-07-31
         * Impression : 1
         * Income : 0.03
         * SiteId : 5046967
         * SiteName : 多云教研室_ios
         * Source : union
         * StartDate : 2020-07-31
         */

        private int AccessMethod;
        private int AppCodeType;
        private int Click;
        private int CodeId;
        private String CodeName;
        private int Cpm;
        private int Ctr;
        private String Currency;
        private String EndDate;
        private int Impression;
        private double Income;
        private int SiteId;
        private String SiteName;
        private String Source;
        private String StartDate;
    }


}
