package com.bxm.mccms.common.model.position;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 素材 数据对象<br/>
 *
 * @author zhengwangeng
 * @since 2020-10-28
 */
@Data
public class CreativeDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标签：多个用逗号分割
     */
    private String tags;

    /**
     * 素材对象
     */
    private List<Creative> creatives;

    @Data
    public static class Creative {
        /**
         * 素材名称
         */
        private String creativeName;

        /**
         * 广告图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
         */
        private String creativePicture;

        /**
         * 素材宽度
         */
        private Integer width;

        /**
         * 素材高度
         */
        private Integer height;

        /**
         * 文件大小
         */
        private Long fileSize;

        /**
         * 文件格式
         */
        private String fileFormat;

        /**
         * md5
         */
        private String md5;

        /**
         * 动画样式
         * @see com.bxm.mccms.facade.enums.SceneDspEntranceCreativeEnum.AnimationStyle
         */
        private Integer animationStyle;
    }
    
}
