package com.bxm.mccms.common.model.position;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import lombok.Data;

/**
 * <p>
 * 素材 详情数据对象
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-10-28
 */
@Data
public class CreativeDetailVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 素材名称
     */
    private String creativeName;

    /**
     * 广告图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativePicture;

    /**
     * 流量开关,1:开,0:关
     */
    private Integer opened;

    /**
     * 标签
     */
    private List<TagInfo> tagInfoList;

    /**
     * 素材宽度
     */
    private Integer width;

    /**
     * 素材高度
     */
    private Integer height;

    /**
     * 文件大小
     */
    private Long fileSize;

    /**
     * 文件格式
     */
    private String fileFormat;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;


    @Data
    public static class TagInfo implements Serializable {

        private static final long serialVersionUID = 1L;

        /**
         * 标签名称：一级标签名称-二级标签名称
         */
        private String tagName;

        /**
         * 标签code
         */
        private String tagCode;
    }
}
