package com.bxm.mccms.common.model.position;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 素材 列表数据对象<br/>
 *
 * @author zhengwangeng
 * @since 2020-10-28
 */
@Data
public class CreativeListVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;

    /**
     * 素材名称
     */
    private String creativeName;

    /**
     * 广告图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativePicture;

    /**
     * 素材宽度
     */
    private Integer width;

    /**
     * 素材高度
     */
    private Integer height;

    /**
     * 流量开关,1:开,0:关
     */
    private Integer opened;


    /***************************** 个性筛选才需要展示的字段 start ****************************/
    /**
     * 标签,展示各式为：一级标签名-二级标签名,一级标签名-二级标签名......
     */
    private String tags;

    /**
     * 文件大小
     */
    private Long fileSize;

    /**
     * 文件格式
     */
    private String fileFormat;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;
    /***************************** 个性筛选才有的字段 end ****************************/
}
