package com.bxm.mccms.common.model.position;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * <p>
 * 广告位审核相关信息
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-28
 */
@Data
public class PositionAuditDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 审核的id
     */
    @NotEmpty(message = "审核ID不能为空")
    private List<Long> ids;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 拒绝原因ID列表
     */
    private String reviewRefuseIds;

    /**
     * 广告位审核状态：1通过,2拒绝
     */
    @NotNull(message = "审核状态不能为空！")
    private Integer state;

}
