package com.bxm.mccms.common.model.position;

import java.math.BigDecimal;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 广告位流量分配<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/25 11:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionDspPosAnalyzeVO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * DSP ID
     */
    private Long dspId;
    /**
     * DSP名称
     */
    private String dspName;
    /**
     * 今日分发量
     */
    private Long todayDosage;
    /**
     * 今日曝光量
     */
    private Long todayExposure;
    /**
     * 今日点击量
     */
    private Long todayHits;
    /**
     * 优先级,1~5升序
     */
    private Integer priority;
    /**
     * 放量底价
     */
    private BigDecimal dspBasePrice;
    /**
     * 流量开关
     * @see com.bxm.mccms.facade.constant.Constants.Opened
     */
    private Integer opened;
    
}
