package com.bxm.mccms.common.model.position;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 广告位流量分配<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/25 11:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionFlowVO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;
    /**
     * 广告位id标识
     */
    private String positionId;
    /**
     * 广告位名称
     */
    private String positionName;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 变现方式：1 标准广告变现，2 组件变现
     */
    private Integer monetizedType;
    /**
     * 广告位类型：1 图文，2 图片，3 文字，4 视频
     */
    private Integer positionType;
    /**
     * 广告位场景：1 开屏，2 互动
     */
    private Integer positionScene;
    /**
     * 广告位尺寸：长*宽
     */
    private String positionSize;
    /**
     * 开发者性质：0 直媒，1 聚合媒体
     */
    private Integer developerType;
    /**
     * 媒体运营
     */
    private String mjName;
    /**
     * 是否已关闭：1 表示已关闭，0 表示未关闭
     */
    private Integer closedFlag;
    
}
