package com.bxm.mccms.common.model.position;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * <p>
 * 广告位状态切换：关闭，开启
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-1-9
 */
@Data
public class PositionStatusSwitchDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位ID
     */
    @NotBlank(message = "广告位positionId不能为空")
    private String positionId;

    /**
     * 是否开关， true开，false关
     */
    @NotNull(message = "开关状态不能为空")
    private Boolean closedFlag;

}
