package com.bxm.mccms.common.model.position;

import com.bxm.mccms.common.core.entity.SceneActivity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 广告位-场景DSP配置 列表数据对象<br/>
 *
 * @author zhengwangeng
 * @since 2020-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SceneActivityVO extends SceneActivity {

    private static final long serialVersionUID = 1L;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动首页pv
     */
    private Integer indexPv;

    /**
     * 活动首页uv
     */
    private Integer indexUv;

    /**
     * 曝光pv
     */
    private Integer exposurePv;

    /**
     * 活动参与率
     */
    private Double joinRate;

    /**
     * 每uv播放
     */
    private Double uvPlay;
    
}
