package com.bxm.mccms.common.model.position;

import java.util.List;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 素材 列表查询对象<br/>
 *
 * @author zhengwangeng
 * @since 2020-10-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SceneDspEntranceCreativeQueryDTO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * id列表
     */
    private List<Integer> ids;

    /**
     * 素材名称
     */
    private String creativeNameKeyword;

    /**
     * 标签
     */
    private List<String> tags;

    /**
     * 流量开关,1:开,0:关   状态
     */
    private Integer opened;

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    private Integer creativeSource;

    /**
     * 创建开始时间
     */
    private String startCreateTime;

    /**
     * 创建结束时间
     */
    private String endCreateTime;

    /**
     * 素材宽度
     */
    private Integer width;

    /**
     * 素材高度
     */
    private Integer height;

    /**
     * 创建人
     */
    private String createUser;
    
}
