package com.bxm.mccms.common.model.position;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

/**
 * 广告位场景设置。</br>
 * Created by zhengwangeng on 2020/5/28 11:29.
 */
@Data
public class SceneSettingDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 活动应用类型：1直接投放，2测试活动
     */
    public static final int TYPE_LAUNCH = 1;
    public static final int TYPE_TEST = 2;

    /**
     * 广告位Id
     */
    @NotBlank(message = "广告位positionId不能为空")
    private String positionId;

    /**
     * 场景类型
     */
    @NotNull(message = "场景类型不能为空")
    private Integer sceneType;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 激励视频广告位
     */
    private String inspireVideoPositionId;

    /**
     * H5链接：互动广告和变现百宝箱，配置内容和互动广告相同，都需要配置该属性
     */
    private String h5Url;

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    private Integer creativeSource;

    /**
     * 广告标题（广告位约束），单个的。
     */
    private String creativeTitle;

    /**
     * 广告内容（广告位约束），多个按英文逗号分隔。允许空元素。如：title,title,,title
     */
    private String creativeContent;

    /**
     * 筛选类型：1标签筛选，2个性筛选
     */
    private Integer screenType;

    /**
     * 筛选值，多个用逗号分割
     */
    private String screenValue;

    /**
     * 活动
     */
    private List<SceneActivity> sceneActivities;

    /**
     * 媒体入口素材
     */
    private List<MediaEntranceCreative> mediaEntranceCreatives;

    @Data
    public static class SceneActivity implements Serializable {

        private static final long serialVersionUID = 1L;

        /**
         * ID
         */
        private Long id;

        /**
         * 广告位ID
         */
        private String positionId;

        /**
         * 活动id
         */
        @NotBlank(message = "活动id不能为空")
        private String activityId;

        /**
         * 活动url
         */
        @NotBlank(message = "活动url不能为空")
        private String activityUrl;

        /**
         * 自定义参数
         */
        private String diyArgs;

        /**
         * 活动应用类型：1直接投放，2测试活动
         */
        @NotNull(message = "活动应用类型不能为空")
        private Integer type;

        /**
         * 有效期开始
         */
        @NotNull(message = "有效期开始不能为空")
        @JsonFormat(pattern = "yyyy-MM-dd")
        private Date startDate;

        /**
         * 有效期结束
         */
        @NotNull(message = "有效期结束不能为空")
        @JsonFormat(pattern = "yyyy-MM-dd")
        private Date endDate;

        /**
         * 流量分配占比
         */
        private Integer rateOfFlow;

        /**
         * 广告位配置json格式
         * [
         *     {
         *         "id": 1,
         *         "positionScene": 1,
         *         "informationFlowTemplate": 2,
         *         "positionId": 804434342111
         *     },
         *     {
         *         "id": 2,
         *         "positionScene": 3,
         *         "informationFlowTemplate": null,
         *         "positionId": 804434342754
         *     }
         * ]
         */
        private String positionConfig;

        /**
         * 开关,1:开,0:关
         */
        @NotNull(message = "活动开关不能为空")
        private Integer opened;
    }

    @Data
    public static class MediaEntranceCreative implements Serializable {

        private static final long serialVersionUID = 1L;

        private Long id;
        private String positionId;
        private Integer positionType;
        private String positionTypeDesc;
        @NotBlank(message = "素材名称不能为空")
        private String creativeName;
        private String creativeIcon;
        private String creativeTitle;
        private String creativeContent;
        private String creativePicture;
        private String creativeCover;
        private String creativeVideo;
        @NotNull(message = "开关状态不能为空")
        private Integer opened;
    }

}

