package com.bxm.mccms.common.model.position;

import org.apache.commons.lang.StringUtils;

import com.bxm.mccms.common.model.base.BaseEntity;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 广告位-场景DSP配置 列表数据对象<br/>
 *
 * @author zhengwangeng
 * @since 2020-05-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SceneSettingListVO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 应用ID
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 广告位名称
     */
    private String positionName;

    /**
     * 广告位类型
     */
    private Integer positionType;

    /**
     * 广告位尺寸
     */
    private String positionSize;

    /**
     * 广告位场景
     */
    private Integer positionScene;

    /**
     * mj_code
     */
    private String mjCode;

    /**
     * 媒介名称
     */
    private String mjName;

    /**
     * 场景类型
     */
    private Integer sceneType;

    public String getCustomPositionType() {
        if (positionScene != null) {
            PositionSceneTypeEnum positionSceneTypeEnum = PositionSceneTypeEnum.get(positionScene);
            if (positionSceneTypeEnum != null) {
                return positionSceneTypeEnum.getCustomPositionTypeEnum().getName();
            }
        }
        return StringUtils.EMPTY;
    }
    
}
