package com.bxm.mccms.common.model.position;

import java.util.List;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 广告位-场景DSP配置 列表查询对象<br/>
 *
 * @author zhengwangeng
 * @since 2020-05-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SceneSettingQueryDTO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    public static final String DSP_CODE = "scene";

    /**
     * 应用ID,名称
     */
    private String appKeyword;

    /**
     * 广告位ID,名称
     */
    private String positionKeyword;

    /**
     * mj_code
     */
    private String mjCode;

    /**
     * 广告位类型
     */
    private Long positionType;

    /**
     * 广告位类型（这个是客户化类型）：1 标准广告，2 非标准广告
     */
    private Integer customPositionType;

    /**
     * 广告位场景
     */
    private List<Integer> positionScenes;

    /**
     * 广告位场景
     */
    private Integer positionScene;

    /**
     * 场景类型
     */
    private Integer sceneType;

    /**
     * dsp code 这里必须是固定的
     */
    private String dspCode = DSP_CODE;
    
}
