package com.bxm.mccms.common.model.task;

import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 任务列表VO对象
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-25
 */
@Data
public class TaskListVO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 任务类型。1- 曝光点击任务、2- 静默唤醒任务、3- 复制任务
     */
    private Integer type;
    
    /**
     * 今日下发次数
     */
    private Long todayAcquires = 0L;
    /**
     * 今日曝光次数
     */
    private Long todayViews = 0L;
    /**
     * 今日点击次数
     */
    private Long todayClicks = 0L;
    /**
     * 今日唤醒准备就绪次数
     */
    private Long todayReadyWakes = 0L;
    /**
     * 今日唤醒完成次数
     */
    private Long todayWakes = 0L;
    /**
     * 今日唤醒成功次数
     */
    private Long todaySuccessWakes = 0L;

    /**
     * 优先级
     */
    private Integer priority;

    /**
     * 状态。1 正常、2 暂停、3 停止、
     */
    private Integer status;

    /**
     * 暂停原因。1-总曝光限制、2-日曝光限制、3-总点击限制、4-日点击限制、5-人工手动暂停、6-总唤醒限制、7-日唤醒限制
     */
    private Integer pauseReason;

    /**
     * 更新时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date modifyTime;

}
