package com.bxm.mccms.common.model.task;

import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;

/**
 * <p>
 * 任务查询对象
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-25
 */
@Data
public class TaskQueryDTO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 任务名称或ID
     */
    private String keyword;

    /**
     * 状态。1 正常、2 暂停、3 停止、
     */
    private Integer status;

    /**
     * 暂停原因。1-总曝光限制、2-日曝光限制、3-总点击限制、4-日点击限制、5-人工手动暂停、6-总唤醒限制、7-日唤醒限制
     */
    private Integer pauseReason;

    /**
     * 任务类型。1- 曝光点击任务、2- 静默唤醒任务
     */
    private Integer type;

}
