package com.bxm.mccms.common.pushable;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.bxm.mccms.common.core.entity.Config;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.constant.pushable.CachePushableTopicEnum;
import com.bxm.mccms.facade.model.pushable.ConfigCacheVO;

import lombok.extern.slf4j.Slf4j;

/**
 * 全局配置<br/>
 *
 * @author kerry.jiang
 * @date 2020/07/09 15:19
 */
@Slf4j
@Component
public class ConfigPushable {

    @Autowired
    private CachePushableIntegration cachePushableIntegration;

    /**
     * 推送<br/>
     */
    public void push(Config t){
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.CONFIG,
                    JSONArray.toJSONBytes(of(t)), null, CachePushableTopicEnum.ADX_SERVICE_CACHE_PUSH);
        }catch (Exception e){
            log.error("push error: t={},e={}",
                    t, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }
    
    /**
     * 转换
     */
    private ConfigCacheVO of(Config t){
        ConfigCacheVO vo = new ConfigCacheVO();
        vo.setConfigKey(t.getConfigKey());
        vo.setConfigValue(t.getConfigValue());
        return vo;
    }
}
