package com.bxm.mccms.common.pushable;

import java.util.Map;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.bxm.mccms.common.core.entity.DspCreative;
import com.bxm.mccms.common.core.entity.PositionDspCreative;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.model.pushable.CreativeCacheVO;
import com.bxm.mccms.facade.model.pushable.CreativePositionRefCacheVO;

import lombok.extern.slf4j.Slf4j;

/**
 * 创意素材<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 15:49
 */
@Slf4j
@Component
public class CreativePushable {

    @Autowired
    private CachePushableIntegration cachePushableIntegration;

    /**
     * 推送<br/>
     */
    public void push(DspCreative t){
        Map<String, Object> parameters = new HashedMap();
        parameters.put(CachePushableFields.TYPE, 1);
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.CREATIVE,
                    JSONArray.toJSONBytes(of(t)), parameters);
        }catch (Exception e){
            log.error("push error: t={},e={}",
                    t, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }

    /**
     * 推送<br/>
     */
    public void push(PositionDspCreative t){
        Map<String, Object> parameters = new HashedMap();
        parameters.put(CachePushableFields.TYPE, 2);
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.CREATIVE,
                    JSONArray.toJSONBytes(of(t)), parameters);
        }catch (Exception e){
            log.error("push error: t={},e={}",
                    t, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }
    
    /**
     * 转换
     */
    private CreativeCacheVO of(DspCreative t){
        CreativeCacheVO vo = new CreativeCacheVO();
        vo.setId(t.getId());
        vo.setDspId(t.getDspId());
        vo.setDspCrtid(t.getDspCrtid());
        vo.setDspAdvtid(t.getDspAdvtid());
        vo.setAuditStatus(t.getAuditStatus().byteValue());
        vo.setType(t.getType().byteValue());
        return vo;
    }
    
    /**
     * 转换
     */
    private CreativePositionRefCacheVO of(PositionDspCreative t){
        CreativePositionRefCacheVO vo = new CreativePositionRefCacheVO();
        vo.setId(t.getId());
        vo.setPositionId(t.getPositionId());
        vo.setCreativeId(t.getCreativeId());
        vo.setAuditStatus(t.getAuditStatus().byteValue());
        return vo;
    }
}
