package com.bxm.mccms.common.pushable;

import java.util.Map;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.bxm.mccms.common.core.entity.PositionDspPos;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.model.pushable.DispatcherCacheVO;

import lombok.extern.slf4j.Slf4j;

/**
 * 流量分发<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 15:49
 */
@Slf4j
@Component
public class DispatcherPushable {

    @Autowired
    private CachePushableIntegration cachePushableIntegration;

    /**
     * 推送<br/>
     */
    public void push(PositionDspPos t){
        Map<String, Object> parameters = new HashedMap();
        parameters.put(CachePushableFields.POSITION_ID, t.getPositionId());
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.DISPATCHER,
                    JSONArray.toJSONBytes(of(t)), parameters);
        }catch (Exception e){
            log.error("push error: t={},e={}",
                    t, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }
    
    /**
     * 转换
     */
    private DispatcherCacheVO of(PositionDspPos t){
        DispatcherCacheVO vo = new DispatcherCacheVO();
        vo.setId(t.getId());
        vo.setPositionId(t.getPositionId());
        vo.setDspId(t.getDspId());
        vo.setDspPosid(t.getDspPosid());
        vo.setDspAppid(t.getDspAppid());
        vo.setPriority(t.getPriority());
        vo.setDspBasePrice(t.getDspBasePrice());
        vo.setOpened(t.getOpened().byteValue());
        return vo;
    }
}
