package com.bxm.mccms.common.pushable;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.bxm.mccms.common.core.entity.Dsp;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.model.pushable.DspCacheVO;

import lombok.extern.slf4j.Slf4j;

/**
 * 广告平台<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 15:49
 */
@Slf4j
@Component
public class DspPushable {

    @Autowired
    private CachePushableIntegration cachePushableIntegration;

    /**
     * 推送<br/>
     */
    public void push(Dsp t){
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.DSP,
                    JSONArray.toJSONBytes(of(t)), null);
        }catch (Exception e){
            log.error("push error: t={},e={}",
                    t, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }
    
    /**
     * 转换
     */
    private DspCacheVO of(Dsp t){
        DspCacheVO vo = new DspCacheVO();
        vo.setId(t.getId());
        vo.setDspCode(t.getDspCode());
        vo.setDspName(t.getDspName());
        vo.setApiUrl(t.getApiUrl());
        vo.setApiKey(t.getApiKey());
        vo.setExt(t.getExt());
        vo.setConnectTimeOut(t.getConnectTimeOut());
        vo.setSocketTimeOut(t.getSocketTimeOut());
        vo.setQps(t.getQps());
        return vo;
    }
}
