package com.bxm.mccms.common.pushable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.bxm.mccms.common.core.entity.SceneActivity;
import com.bxm.mccms.common.core.entity.SceneDspEntranceCreative;
import com.bxm.mccms.common.core.entity.SceneSetting;
import com.bxm.mccms.common.core.service.ISceneActivityService;
import com.bxm.mccms.common.core.service.ISceneDspEntranceCreativeService;
import com.bxm.mccms.common.core.service.ISceneSettingService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.constant.pushable.CachePushableTopicEnum;
import com.bxm.mccms.facade.model.pushable.SceneSettingCacheVO;

import lombok.extern.slf4j.Slf4j;

/**
 * 广告位场景DSP推送<br/>
 *
 * @author zhengwangeng
 * @since 2020-05-28
 */
@Slf4j
@Component
public class PositionSceneSettingPushable {

    @Autowired
    private CachePushableIntegration cachePushableIntegration;
    @Autowired
    private ISceneSettingService sceneSettingService;
    @Autowired
    private ISceneDspEntranceCreativeService sceneDspEntranceCreativeService;
    @Autowired
    private ISceneActivityService sceneActivityService;

    /**
     * 推送<br/>
     */
    public void push(String positionId){
        Map<String, Object> parameters = new HashedMap();
        parameters.put(CachePushableFields.POSITION_ID, positionId);
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.SCENE_SETTING,
                    JSONArray.toJSONBytes(of(positionId)), parameters, CachePushableTopicEnum.DEFAULT);
        }catch (Exception e){
            log.error("push error: positionId={},e={}",
                    positionId, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }
    
    /**
     * 转换
     */
    private SceneSettingCacheVO of(String positionId) throws Exception {
        SceneSettingCacheVO vo = new SceneSettingCacheVO();

        SceneSetting sceneSetting = sceneSettingService.findOneByOneParamWithNotNull(SceneSetting.POSITION_ID, positionId);
        BeanUtils.copyProperties(sceneSetting, vo);

        //场景素材
        List<SceneDspEntranceCreative> sceneDspEntranceCreativeList =
                sceneDspEntranceCreativeService.findListByOneParam(SceneDspEntranceCreative.POSITION_ID, positionId);
        if (CollectionUtils.isNotEmpty(sceneDspEntranceCreativeList)) {
            ArrayList<SceneSettingCacheVO.MediaEntranceCreative> mediaEntranceCreatives = new ArrayList<>(sceneDspEntranceCreativeList.size());
            for (SceneDspEntranceCreative sceneDspEntranceCreative : sceneDspEntranceCreativeList) {
                SceneSettingCacheVO.MediaEntranceCreative mediaEntranceCreative =
                        new SceneSettingCacheVO.MediaEntranceCreative();
                BeanUtils.copyProperties(sceneDspEntranceCreative, mediaEntranceCreative);
                mediaEntranceCreative.setCreativeId(sceneDspEntranceCreative.getId());
                mediaEntranceCreatives.add(mediaEntranceCreative);
            }

            vo.setMediaEntranceCreatives(mediaEntranceCreatives);
        }

        //场景活动
        List<SceneActivity> sceneActivityList =
                sceneActivityService.findListByOneParam(SceneActivity.POSITION_ID, positionId);
        if (CollectionUtils.isNotEmpty(sceneActivityList)) {
            ArrayList<SceneSettingCacheVO.SceneActivity> sceneActivities = new ArrayList<>(sceneActivityList.size());
            for (SceneActivity sceneDspEntranceCreative : sceneActivityList) {
                SceneSettingCacheVO.SceneActivity sceneActivity =
                        new SceneSettingCacheVO.SceneActivity();
                BeanUtils.copyProperties(sceneDspEntranceCreative, sceneActivity);
                sceneActivities.add(sceneActivity);
            }

            vo.setSceneActivities(sceneActivities);
        }
        return vo;
    }
}
