package com.bxm.mccms.common.pushable;

import java.io.Serializable;
import java.util.Map;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.bxm.mccms.common.core.entity.ShieldStrategy;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.model.pushable.ShieldStrategyCacheVO;

import lombok.extern.slf4j.Slf4j;

/**
 * 屏蔽策略<br/>
 *
 * @author zhengwangeng
 * @since 2020-01-11
 */
@Slf4j
@Component
public class ShieldStrategyPushable {

    @Autowired
    private CachePushableIntegration cachePushableIntegration;

    /**
     * 推送<br/>
     */
    public void push(ShieldStrategy t){
        Map<String, Object> parameters = new HashedMap();
        parameters.put(CachePushableFields.SHIELD_STRATEGY_ID, t.getId());
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.SHIELD_STRATEGY,
                    JSONArray.toJSONBytes(of(t)), parameters);
        }catch (Exception e){
            log.error("push error: t={},e={}",
                    t, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }

    /**
     * 推送 删除的<br/>
     */
    public void delete(Serializable id){
        Map<String, Object> parameters = new HashedMap();
        parameters.put(CachePushableFields.SHIELD_STRATEGY_ID, id);
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.SHIELD_STRATEGY,
                    null, parameters);
        }catch (Exception e){
            log.error("push error: t={},e={}",
                    id, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }
    
    /**
     * 转换
     */
    private ShieldStrategyCacheVO of(ShieldStrategy t){
        ShieldStrategyCacheVO vo = new ShieldStrategyCacheVO();
        vo.setId(t.getId());
        vo.setStrategyName(t.getStrategyName());
        vo.setShieldKeyword(t.getShieldKeyword());
        vo.setAndroidPackageName(t.getAndroidPackageName());
        vo.setIosId(t.getIosId());
        return vo;
    }
}
