package com.bxm.mccms.common.pushable;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.adx.facade.rule.task.Rule;
import com.bxm.adx.facade.rule.task.TaskOfRules;
import com.bxm.mccms.common.core.entity.Task;
import com.bxm.mccms.common.core.entity.TaskRules;
import com.bxm.mccms.common.core.service.ITaskRulesService;
import com.bxm.mccms.common.core.service.ITaskService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.pushable.CachePushableIntegration;
import com.bxm.mccms.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.mccms.facade.constant.pushable.CachePushableTopicEnum;
import com.bxm.mccms.facade.enums.RuleTypeEnum;

import lombok.extern.slf4j.Slf4j;

/**
 * 任务<br/>
 *
 * @author zhengwangeng
 * @since 2020-03-25
 */
@Slf4j
@Component
public class TaskPushable {

    @Autowired
    private CachePushableIntegration cachePushableIntegration;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private ITaskRulesService taskRulesService;

    /**
     * 推送<br/>
     */
    public void push(Long taskId){
        Map<String, Object> parameters = new HashedMap();
        parameters.put(CachePushableFields.TASK_ID, taskId);
        try {
            cachePushableIntegration.push(CachePushableServiceEnum.TASK,
                    JSONArray.toJSONBytes(of(taskId)), parameters, CachePushableTopicEnum.ADX_SERVICE_CACHE_PUSH);
        }catch (Exception e){
            log.error("push error: taskId={},e={}",
                    taskId, ExceptionUtils.getFullStackTrace(e));
            throw new McCmsException("消息推送失败");
        }
    }
    
    /**
     * 转换
     */
    private TaskOfRules of(Long taskId){
        Task task = taskService.getById(taskId);
        TaskOfRules vo = new TaskOfRules();
        BeanUtils.copyProperties(task, vo);

        QueryWrapper<TaskRules> taskQueryWrapper = new QueryWrapper<>();
        taskQueryWrapper.eq(TaskRules.TASK_ID, task.getId());
        List<TaskRules> taskRules = taskRulesService.list(taskQueryWrapper);
        if (CollectionUtils.isNotEmpty(taskRules)) {
            for (TaskRules taskRule : taskRules) {
                RuleTypeEnum ruleTypeEnum = RuleTypeEnum.get(taskRule.getRuleType());
                if (ruleTypeEnum == null) {
                    continue;
                }
                switch (ruleTypeEnum) {
                    case REGION:
                        Rule rule = new Rule();
                        BeanUtils.copyProperties(taskRule, rule);
                        vo.setRegion(rule);
                        break;
                    case POSITION:
                        Rule position = new Rule();
                        BeanUtils.copyProperties(taskRule, position);
                        vo.setPosition(position);
                        break;
                    case FREQUENCYS:
                        Rule frequencys = new Rule();
                        BeanUtils.copyProperties(taskRule, frequencys);
                        vo.setFrequencys(frequencys);
                        break;
                    case APP:
                        Rule app = new Rule();
                        BeanUtils.copyProperties(taskRule, app);
                        vo.setApps(app);
                        break;
                    case DEVICE_BRAND:
                        Rule deviceBrand = new Rule();
                        BeanUtils.copyProperties(taskRule, deviceBrand);
                        vo.setDeviceBrands(deviceBrand);
                        break;
                    case TIME_SLOT:
                        Rule timeSlot = new Rule();
                        BeanUtils.copyProperties(taskRule, timeSlot);
                        vo.setTimeSlots(timeSlot);
                        break;
                    default:
                        break;
                }
            }
        }
        return vo;
    }
}
