/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.Config;
import com.bxm.mccms.common.core.mapper.ConfigMapper;
import com.bxm.mccms.common.core.service.IConfigService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.pushable.ConfigPushable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigServiceImpl
extends ServiceImpl<ConfigMapper, Config>
implements IConfigService {
    @Autowired
    private ConfigPushable configPushable;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean update(Config dto) {
        Config config = (Config)((ConfigMapper)this.getBaseMapper()).selectById(dto.getId());
        if (null == config) {
            throw new McCmsException("\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", new Object[0]);
        }
        config.setConfigValue(dto.getConfigValue());
        config.setModifyUser(dto.getModifyUser());
        config.setModifyTime(dto.getModifyTime());
        Boolean flag = ((ConfigMapper)this.getBaseMapper()).updateById(config) > 0;
        this.configPushable.push(config);
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchUpdate(List<Config> dtos) {
        ArrayList<Config> list = new ArrayList<Config>();
        int count = 0;
        for (Config dto : dtos) {
            Config config = (Config)((ConfigMapper)this.getBaseMapper()).selectById(dto.getId());
            if (null == config) {
                throw new McCmsException("\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", new Object[0]);
            }
            config.setConfigValue(dto.getConfigValue());
            config.setModifyUser(dto.getModifyUser());
            config.setModifyTime(dto.getModifyTime());
            count += ((ConfigMapper)this.getBaseMapper()).updateById(config);
            list.add(config);
        }
        Boolean flag = count > 0;
        if (flag.booleanValue()) {
            for (Config config : list) {
                this.configPushable.push(config);
            }
        }
        return flag;
    }
}

