/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.DeveloperBill;
import com.bxm.mccms.common.core.mapper.DeveloperBillMapper;
import com.bxm.mccms.common.core.service.IDeveloperBillService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.model.income.DeveloperBillDTO;
import com.bxm.mccms.common.model.income.DeveloperBillVO;
import com.bxm.mccms.common.model.income.DeveloperWithdrawlVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeveloperBillServiceImpl
extends ServiceImpl<DeveloperBillMapper, DeveloperBill>
implements IDeveloperBillService {
    private static final Logger log = LoggerFactory.getLogger(DeveloperBillServiceImpl.class);
    @Autowired
    private DeveloperIntegration developerIntegration;
    @Autowired
    private DeveloperBillMapper developerBillMapper;

    @Override
    public boolean init() {
        String month = LocalDate.now().plusMonths(-1L).format(DateTimeFormatter.ofPattern("yyyy-MM"));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"month", (Object)month);
        if (CollectionUtils.isNotEmpty((Collection)this.list((Wrapper)queryWrapper))) {
            log.warn("[{}] Developer Bill ", (Object)month);
            return false;
        }
        List<DeveloperBill> developerBills = this.developerBillMapper.selectByMonth(month);
        return this.saveBatch(developerBills);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public Boolean publish(Long id, String month) {
        UserVo user = UserRoleUtil.getUser();
        if (id != null) {
            DeveloperBill bill = (DeveloperBill)this.getById(id);
            if (bill == null) {
                throw new McCmsException("\u6ca1\u6709\u5bf9\u5e94\u7684\u8d26\u5355" + id, new Object[0]);
            }
            if (0 != bill.getStatus()) {
                throw new McCmsException("\u8d26\u5355\u4e0d\u662f\u672a\u786e\u8ba4\u72b6\u6001" + id, new Object[0]);
            }
            bill.setStatus(1);
            bill.setModifyUser(user.getUsername());
            return this.updateById(bill);
        }
        DeveloperBill bill = new DeveloperBill();
        bill.setStatus(1);
        bill.setModifyUser(user.getUsername());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"month", (Object)month);
        updateWrapper.eq((Object)"status", (Object)0);
        return this.update(bill, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public Boolean deduction(String remark, BigDecimal money, Long id) {
        UserVo user = UserRoleUtil.getUser();
        DeveloperBill bill = (DeveloperBill)this.getById(id);
        if (bill == null) {
            throw new McCmsException("\u6ca1\u6709\u5bf9\u5e94\u7684\u8d26\u5355" + id, new Object[0]);
        }
        if (0 != bill.getStatus()) {
            throw new McCmsException("\u8d26\u5355\u4e0d\u662f\u672a\u786e\u8ba4\u72b6\u6001" + id, new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(bill.getDeductionLog()).append("\u64cd\u4f5c\u4eba:").append(user.getUsername()).append(",\u52a0\u6b3e").append(money).append(",\u539f\u56e0:").append(remark).append(";");
        bill.setDeductionLog(sb.toString());
        bill.setCashMoney(money.add(bill.getCashMoney()));
        bill.setModifyUser(user.getUsername());
        return this.updateById(bill);
    }

    @Override
    public IPage<DeveloperBillVO> findAll(DeveloperBillDTO query) {
        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        dto.setMjCode(query.getMj());
        dto.setDeveloperKeyword(query.getKeywords());
        List<DeveloperFacadeVO> providerAppList = this.developerIntegration.list(dto);
        if (CollectionUtils.isEmpty(providerAppList)) {
            log.warn("Developer List  is Empty . ");
            return new Page();
        }
        Map<Long, DeveloperFacadeVO> collect = providerAppList.stream().collect(Collectors.toMap(DeveloperFacadeVO::getId, DeveloperFacadeVO2 -> DeveloperFacadeVO2));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"month", (Object)query.getMonth());
        queryWrapper.in((Object)"developer_id", (Collection)providerAppList.stream().map(DeveloperFacadeVO::getId).collect(Collectors.toList()));
        Page p = new Page();
        p.setCurrent((long)query.getCurrent().intValue());
        p.setSize((long)query.getSize().intValue());
        IPage page = this.page((IPage)p, (Wrapper)queryWrapper);
        Page result = new Page();
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return result;
        }
        BeanUtils.copyProperties((Object)page, (Object)result);
        ArrayList developerBillVOList = new ArrayList(page.getRecords().size());
        page.getRecords().forEach(developerBill -> {
            DeveloperBillVO vo = new DeveloperBillVO();
            BeanUtils.copyProperties((Object)developerBill, (Object)vo);
            vo.setDeveloperName(((DeveloperFacadeVO)collect.get(vo.getDeveloperId())).getDeveloperName());
            vo.setMj(((DeveloperFacadeVO)collect.get(vo.getDeveloperId())).getMjName());
            developerBillVOList.add(vo);
        });
        result.setRecords(developerBillVOList);
        return result;
    }

    @Override
    public IPage<DeveloperWithdrawlVO> findWithdrawalAll(DeveloperBillDTO query) {
        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        dto.setDeveloperKeyword(query.getKeywords());
        List<DeveloperFacadeVO> providerAppList = this.developerIntegration.list(dto);
        if (CollectionUtils.isEmpty(providerAppList)) {
            return new Page();
        }
        Map<Long, DeveloperFacadeVO> collect = providerAppList.stream().collect(Collectors.toMap(DeveloperFacadeVO::getId, DeveloperFacadeVO2 -> DeveloperFacadeVO2, (v1, v2) -> v2));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"month", (Object)query.getMonth());
        queryWrapper.in((Object)"developer_id", (Collection)providerAppList.stream().map(DeveloperFacadeVO::getId).collect(Collectors.toList()));
        queryWrapper.ge((Object)"month", (Object)query.getStartDate());
        queryWrapper.le((Object)"month", (Object)query.getEndDate());
        Page p = new Page();
        p.setCurrent((long)query.getCurrent().intValue());
        p.setSize((long)query.getSize().intValue());
        IPage page = this.page((IPage)p, (Wrapper)queryWrapper);
        page.getRecords().forEach(vo -> {
            DeveloperFacadeVO develeper = (DeveloperFacadeVO)collect.get(vo.getDeveloperId());
            if (develeper == null) {
                return;
            }
            vo.setDeveloperName(develeper.getDeveloperName());
            vo.setCompanyName(develeper.getCompanyName());
        });
        return page;
    }
}

