/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.DeveloperIncome;
import com.bxm.mccms.common.core.entity.PositionIncome;
import com.bxm.mccms.common.core.mapper.DeveloperIncomeMapper;
import com.bxm.mccms.common.core.mapper.PositionIncomeMapper;
import com.bxm.mccms.common.core.service.IDeveloperIncomeService;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.model.income.DeveloperIncomeDTO;
import com.bxm.mccms.common.model.income.DeveloperIncomeVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DeveloperIncomeServiceImpl
extends ServiceImpl<DeveloperIncomeMapper, DeveloperIncome>
implements IDeveloperIncomeService {
    private static final Logger log = LoggerFactory.getLogger(DeveloperIncomeServiceImpl.class);
    @Autowired
    private DeveloperIncomeMapper developerIncomeMapper;
    @Autowired
    private DeveloperIntegration developerIntegration;
    @Autowired
    private PositionIncomeMapper positionIncomeMapper;

    @Override
    public int init() {
        return this.developerIncomeMapper.init(LocalDateTimeHelper.plusDayString((long)-1L, (String)"yyyy-MM-dd"));
    }

    @Override
    public IPage<DeveloperIncomeVO> findAll(UserVo user, Page<DeveloperIncome> page, DeveloperIncomeDTO query) {
        String mjCode = query.getMj();
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank((CharSequence)mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page();
            }
            mjCode = user.getUsername();
        }
        query.setMj(mjCode);
        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        dto.setMjCode(query.getMj());
        dto.setDeveloperKeyword(query.getKeywords());
        List<DeveloperFacadeVO> providerAppList = this.developerIntegration.list(dto);
        if (CollectionUtils.isEmpty(providerAppList)) {
            log.warn("Developer List is Empty . mj = {}", (Object)dto.getMjCode());
            return new Page();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (query.getDeveloperId() != null) {
            queryWrapper.eq((Object)"developer_id", (Object)query.getDeveloperId());
        }
        List providerIdList = providerAppList.stream().map(DeveloperFacadeVO::getId).collect(Collectors.toList());
        queryWrapper.in((Object)"developer_id", providerIdList);
        if (StringUtils.isNotBlank((CharSequence)query.getDatetime())) {
            queryWrapper.eq((Object)"datetime", (Object)query.getDatetime());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getStartDate()) && StringUtils.isNotBlank((CharSequence)query.getEndDate())) {
            queryWrapper.ge((Object)"datetime", (Object)query.getStartDate());
            queryWrapper.le((Object)"datetime", (Object)query.getEndDate());
        }
        Map<Long, DeveloperFacadeVO> collect = providerAppList.stream().collect(Collectors.toMap(DeveloperFacadeVO::getId, DeveloperFacadeVO2 -> DeveloperFacadeVO2));
        IPage incomeIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        Page result = new Page();
        if (CollectionUtils.isEmpty((Collection)incomeIPage.getRecords())) {
            return result;
        }
        BeanUtils.copyProperties((Object)incomeIPage, (Object)result);
        ArrayList developerIncomeVOS = new ArrayList(incomeIPage.getRecords().size());
        incomeIPage.getRecords().forEach(developerIncome -> {
            DeveloperIncomeVO vo = new DeveloperIncomeVO();
            BeanUtils.copyProperties((Object)developerIncome, (Object)vo);
            vo.setDeveloperName(((DeveloperFacadeVO)collect.get(vo.getDeveloperId())).getDeveloperName());
            developerIncomeVOS.add(vo);
        });
        result.setRecords(developerIncomeVOS);
        return result;
    }

    @Override
    public Boolean download(String datetime, String token) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (requestAttributes != null);
        HttpServletResponse response = requestAttributes.getResponse();
        return Boolean.TRUE;
    }

    @Override
    public Boolean upload(MultipartFile request, String token) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean publish(String datetime) {
        UserVo user = UserRoleUtil.getUser();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"datetime", (Object)datetime);
        updateWrapper.lt((Object)"status", (Object)2);
        DeveloperIncome income = new DeveloperIncome();
        income.setStatus(2);
        income.setModifyUser(user.getUsername());
        this.positionIncomeMapper.updateStatusByDatetime(2, user.getUsername(), datetime);
        return this.update(income, (Wrapper)updateWrapper);
    }

    @Override
    public void updateConsume(List<PositionIncome> positionIncomes) {
        positionIncomes.forEach(income -> {
            if (income == null) {
                return;
            }
            DeveloperIncome developerIncome = new DeveloperIncome();
            developerIncome.setModifyUser(income.getModifyUser());
            developerIncome.setBxmPreIncome(income.getBxmPreIncome());
            developerIncome.setDeveloperPreIncome(income.getPositionPreIncome());
            developerIncome.setTotalClick(income.getTotalClick());
            developerIncome.setTotalIncome(income.getTotalIncome());
            developerIncome.setTotalOpen(income.getTotalOpen());
            developerIncome.setTotalSend(income.getTotalSend());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"datetime", (Object)income.getDatetime());
            updateWrapper.eq((Object)"developer_id", (Object)income.getDeveloperId());
            this.update(developerIncome, (Wrapper)updateWrapper);
        });
    }
}

