/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.DeveloperBill;
import com.bxm.mccms.common.core.entity.DeveloperWithdrawal;
import com.bxm.mccms.common.core.mapper.DeveloperBillMapper;
import com.bxm.mccms.common.core.mapper.DeveloperWithdrawalMapper;
import com.bxm.mccms.common.core.service.IDeveloperWithdrawalService;
import com.bxm.mccms.common.core.service.impl.DeveloperBillServiceImpl;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.model.income.DeveloperBillDTO;
import com.bxm.mccms.common.model.income.DeveloperWithdrawlVO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeveloperWithdrawalServiceImpl
extends ServiceImpl<DeveloperWithdrawalMapper, DeveloperWithdrawal>
implements IDeveloperWithdrawalService {
    @Autowired
    private DeveloperBillMapper developerBillMapper;
    @Autowired
    private DeveloperIntegration developerIntegration;
    @Autowired
    private DeveloperBillServiceImpl developerBillService;

    @Override
    public IPage<DeveloperWithdrawlVO> findAll(Page<DeveloperBill> developerBillPage, DeveloperBillDTO query) {
        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        dto.setDeveloperKeyword(query.getKeywords());
        List<DeveloperFacadeVO> providerAppList = this.developerIntegration.list(dto);
        if (CollectionUtils.isEmpty(providerAppList)) {
            this.log.warn("Developer List  is Empty . ");
            return new Page();
        }
        Map<Long, DeveloperFacadeVO> collect = providerAppList.stream().collect(Collectors.toMap(DeveloperFacadeVO::getId, DeveloperFacadeVO2 -> DeveloperFacadeVO2));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ge(StringUtils.isNotBlank((CharSequence)query.getStartDate()), (Object)"month", (Object)query.getStartDate());
        queryWrapper.le(StringUtils.isNotBlank((CharSequence)query.getEndDate()), (Object)"month", (Object)query.getEndDate());
        queryWrapper.in((Object)"developer_id", (Collection)providerAppList.stream().map(DeveloperFacadeVO::getId).collect(Collectors.toList()));
        queryWrapper.eq(null != query.getStatus(), (Object)"status", (Object)query.getStatus());
        Page p = new Page();
        p.setCurrent((long)query.getCurrent().intValue());
        p.setSize((long)query.getSize().intValue());
        IPage page = this.developerBillService.page((IPage)p, (Wrapper)queryWrapper);
        Page result = new Page();
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return result;
        }
        QueryWrapper withdrawalQueryWrapper = new QueryWrapper();
        withdrawalQueryWrapper.ge(StringUtils.isNotBlank((CharSequence)query.getStartDate()), (Object)"month", (Object)query.getStartDate());
        withdrawalQueryWrapper.le(StringUtils.isNotBlank((CharSequence)query.getEndDate()), (Object)"month", (Object)query.getEndDate());
        List list = this.list((Wrapper)withdrawalQueryWrapper);
        HashMap developerWithdrawalMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(developerWithdrawal -> developerWithdrawalMap.put(developerWithdrawal.getDeveloperId() + developerWithdrawal.getMonth(), developerWithdrawal));
        }
        BeanUtils.copyProperties((Object)page, (Object)result);
        ArrayList developerBillVOList = new ArrayList(page.getRecords().size());
        page.getRecords().forEach(developerBill -> {
            DeveloperWithdrawlVO vo = new DeveloperWithdrawlVO();
            vo.setCompanyName(((DeveloperFacadeVO)collect.get(developerBill.getDeveloperId())).getCompanyName());
            vo.setDeveloperName(((DeveloperFacadeVO)collect.get(developerBill.getDeveloperId())).getDeveloperName());
            vo.setMonth(developerBill.getMonth());
            vo.setCashMoney(developerBill.getCashMoney());
            DeveloperWithdrawal developerWithdrawal = (DeveloperWithdrawal)developerWithdrawalMap.get(developerBill.getDeveloperId() + developerBill.getMonth());
            if (developerWithdrawal != null) {
                BeanUtils.copyProperties((Object)developerWithdrawal, (Object)vo);
            }
            vo.setTotalConsume(developerBill.getTotalConsume());
            vo.setDeveloperIncome(developerBill.getDeveloperIncome());
            if (vo.getStatus() == null) {
                vo.setStatus(developerBill.getStatus());
            }
            if (vo.getDeveloperId() == null) {
                vo.setDeveloperId(developerBill.getDeveloperId());
            }
            developerBillVOList.add(vo);
        });
        result.setRecords(developerBillVOList);
        return result;
    }

    @Override
    public Boolean publish(Long id) {
        DeveloperWithdrawal withdrawal = (DeveloperWithdrawal)this.getById(id);
        if (withdrawal == null) {
            throw new McCmsException("\u6ca1\u6709\u5bf9\u5e94\u7684\u8d26\u5355\uff0cid = " + id, new Object[0]);
        }
        if (3 != withdrawal.getStatus()) {
            throw new McCmsException("\u8d26\u5355\u4e0d\u662f\u63d0\u73b0\u4e2d\u7684\u72b6\u6001\uff0cid = " + id, new Object[0]);
        }
        UserVo user = UserRoleUtil.getUser();
        withdrawal.setModifyUser(user.getUsername());
        withdrawal.setStatus(5);
        withdrawal.setWithdrawalTime(new Date());
        this.saveOrUpdate(withdrawal);
        DeveloperBill bill = new DeveloperBill();
        bill.setStatus(5);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"month", (Object)withdrawal.getMonth());
        updateWrapper.eq((Object)"developer_id", (Object)withdrawal.getDeveloperId());
        this.developerBillMapper.update(bill, (Wrapper)updateWrapper);
        return true;
    }
}

