/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.DspCreative;
import com.bxm.mccms.common.core.mapper.DspCreativeMapper;
import com.bxm.mccms.common.core.service.IDspCreativeService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.model.dsp.DspCreativeDTO;
import com.bxm.mccms.common.pushable.CreativePushable;
import com.bxm.mccms.facade.model.adx.CreativeFacadeVO;
import com.bxm.mccms.facade.model.adx.CreativeReviewFacadeVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dspCreativeServiceImpl")
public class DspCreativeServiceImpl
extends ServiceImpl<DspCreativeMapper, DspCreative>
implements IDspCreativeService {
    @Autowired
    private CreativePushable creativePushable;

    @Override
    public Page<DspCreative> pageByAudit(Page page, DspCreativeDTO query) {
        Page<DspCreative> resp = ((DspCreativeMapper)this.getBaseMapper()).pageByAudit(page, query);
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> batchSave(List<DspCreative> dspCreatives) {
        ArrayList<String> crtIds = new ArrayList<String>();
        for (DspCreative dspCreative : dspCreatives) {
            boolean result = this.save(dspCreative);
            if (!result) continue;
            crtIds.add(dspCreative.getDspCrtid());
        }
        return crtIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> batchUpdate(List<DspCreative> dspCreatives) {
        ArrayList<String> crtIds = new ArrayList<String>();
        for (DspCreative dspCreative : dspCreatives) {
            String dspCrtId = dspCreative.getDspCrtid();
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"dsp_crtid", (Object)dspCrtId);
            updateWrapper.eq((Object)"dsp_id", (Object)dspCreative.getDspId());
            boolean result = this.update(dspCreative, (Wrapper)updateWrapper);
            if (!result) continue;
            crtIds.add(dspCrtId);
        }
        return crtIds;
    }

    @Override
    public List<CreativeFacadeVO> queryCreativeByIds(List<String> dspCrtIds, Long dspId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"dsp_crtid", dspCrtIds);
        queryWrapper.eq((Object)"dsp_id", (Object)dspId);
        List dspCreatives = this.list((Wrapper)queryWrapper);
        ArrayList<CreativeFacadeVO> creativeFacadeVOS = new ArrayList<CreativeFacadeVO>();
        for (DspCreative dspCreative : dspCreatives) {
            CreativeFacadeVO creativeFacadeVO = new CreativeFacadeVO();
            BeanUtils.copyProperties((Object)dspCreative, (Object)creativeFacadeVO);
            creativeFacadeVOS.add(creativeFacadeVO);
        }
        return creativeFacadeVOS;
    }

    @Override
    public List<CreativeReviewFacadeVO> queryReviewStatus(List<String> dspCrtIds, Long dspId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"dsp_crtid", dspCrtIds);
        queryWrapper.eq((Object)"dsp_id", (Object)dspId);
        List dspCreatives = this.list((Wrapper)queryWrapper);
        ArrayList<CreativeReviewFacadeVO> creativeReviewFacadeVOS = new ArrayList<CreativeReviewFacadeVO>();
        for (DspCreative dspCreative : dspCreatives) {
            CreativeReviewFacadeVO creativeReviewFacadeVO = new CreativeReviewFacadeVO();
            BeanUtils.copyProperties((Object)dspCreative, (Object)creativeReviewFacadeVO);
            creativeReviewFacadeVOS.add(creativeReviewFacadeVO);
        }
        return creativeReviewFacadeVOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateAuditStatus(DspCreative body) {
        DspCreative t = (DspCreative)this.getById(body.getId());
        if (null == t) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]);
        }
        t.setAuditStatus(body.getAuditStatus());
        if (StringUtils.isNotBlank((CharSequence)body.getFailReason())) {
            t.setFailReason(body.getFailReason());
        }
        if (StringUtils.isNotBlank((CharSequence)body.getRemark())) {
            t.setRemark(body.getRemark());
        }
        t.setAuditTime(new Date());
        ((DspCreativeMapper)this.getBaseMapper()).updateById(t);
        this.creativePushable.push(t);
        return Boolean.TRUE;
    }
}

