/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.Dsp;
import com.bxm.mccms.common.core.mapper.DspMapper;
import com.bxm.mccms.common.core.service.IDspService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.pushable.DspPushable;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DspServiceImpl
extends ServiceImpl<DspMapper, Dsp>
implements IDspService {
    @Autowired
    private DspPushable dspPushable;

    @Override
    public IPage<Dsp> pageByLike(Page page, Dsp query) {
        if (CollectionUtils.isEmpty((Collection)page.getOrders())) {
            page.setOrders((List)Lists.newArrayList((Object[])new OrderItem[]{OrderItem.desc((String)"id")}));
        }
        LambdaQueryWrapper wrapper = new QueryWrapper().lambda();
        if (StringUtils.isNotBlank((CharSequence)query.getDspName())) {
            wrapper.and(c -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)c.like(Dsp::getDspName, (Object)query.getDspName())).or()).like(Dsp::getId, (Object)query.getDspName());
            });
        }
        return ((DspMapper)this.getBaseMapper()).selectPage((IPage)page, (Wrapper)wrapper);
    }

    @Override
    public List<IDAndNameVO> list(String keyword) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(Dsp::getDeleted, (Object)0);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            queryWrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Dsp::getDspName, (Object)keyword)).or()).like(Dsp::getId, (Object)keyword);
            });
        }
        List list = super.list((Wrapper)queryWrapper);
        ArrayList<IDAndNameVO> resps = new ArrayList<IDAndNameVO>();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resps;
        }
        for (Dsp dsp : list) {
            IDAndNameVO resp = new IDAndNameVO();
            resp.setId(dsp.getId());
            resp.setName(dsp.getDspName());
            resps.add(resp);
        }
        return resps;
    }

    @Override
    public Dsp getByOnly(String dspCode) {
        LambdaQueryWrapper wrapper = new QueryWrapper().lambda();
        wrapper.eq(Dsp::getDspCode, (Object)dspCode);
        List list = ((DspMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (Dsp)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean saveInfo(Dsp t) {
        Dsp old = this.getByOnly(t.getDspCode());
        if (null != old) {
            throw new McCmsException("\u5e73\u53f0\u4ee3\u7801\u201c" + t.getDspCode() + "\u201d\u5df2\u5b58\u5728", new Object[0]);
        }
        int rows = ((DspMapper)this.getBaseMapper()).insert(t);
        this.dspPushable.push((Dsp)this.getById(t.getId()));
        return rows > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateInfo(Dsp t) {
        Dsp old = this.getByOnly(t.getDspCode());
        if (null != old && !Objects.equals(old.getId(), t.getId())) {
            throw new McCmsException("\u5e73\u53f0\u4ee3\u7801\u201c" + t.getDspCode() + "\u201d\u5df2\u5b58\u5728", new Object[0]);
        }
        int rows = ((DspMapper)this.getBaseMapper()).updateById(t);
        this.dspPushable.push((Dsp)this.getById(t.getId()));
        return rows > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateDeleted(Long id, Integer deleted) {
        Dsp t = (Dsp)this.getById(id);
        if (null == t) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]);
        }
        t.setDeleted(deleted);
        ((DspMapper)this.getBaseMapper()).updateById(t);
        this.dspPushable.push(t);
        return Boolean.TRUE;
    }
}

