/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.PositionCalcConfig;
import com.bxm.mccms.common.core.mapper.PositionCalcConfigMapper;
import com.bxm.mccms.common.core.service.IPositionCalcConfigService;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionCalcConfigServiceImpl
extends ServiceImpl<PositionCalcConfigMapper, PositionCalcConfig>
implements IPositionCalcConfigService {
    private static final Logger log = LoggerFactory.getLogger(PositionCalcConfigServiceImpl.class);
    @Autowired
    private PositionIntegration positionIntegration;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sycnPositionCalcConfig() {
        PositionFacadeQueryDTO dto = new PositionFacadeQueryDTO();
        List<PositionFacadeVO> positionList = this.positionIntegration.getAllList(dto);
        if (CollectionUtils.isEmpty(positionList)) {
            log.debug("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5e7f\u544a\u4f4d");
            return;
        }
        ArrayList<PositionCalcConfig> positionCalcConfigList = new ArrayList<PositionCalcConfig>();
        Date modifyTime = new Date();
        for (PositionFacadeVO positionFacadeVO : positionList) {
            PositionCalcConfig positionCalcConfig = new PositionCalcConfig();
            positionCalcConfigList.add(positionCalcConfig);
            positionCalcConfig.setPositionId(positionFacadeVO.getPositionId());
            positionCalcConfig.setCooperationType(positionFacadeVO.getCooperationType());
            positionCalcConfig.setDivideInto(positionFacadeVO.getDivideInto());
            positionCalcConfig.setBiddingType(positionFacadeVO.getBiddingType());
            positionCalcConfig.setBasePrice(positionFacadeVO.getBasePrice());
            positionCalcConfig.setStartDate(positionFacadeVO.getStartDate());
            positionCalcConfig.setEndDate(positionFacadeVO.getEndDate());
            positionCalcConfig.setOldCooperationType(positionCalcConfig.getCooperationType());
            positionCalcConfig.setOldDivideInto(positionCalcConfig.getDivideInto());
            positionCalcConfig.setOldBiddingType(positionCalcConfig.getBiddingType());
            positionCalcConfig.setOldBasePrice(positionCalcConfig.getBasePrice());
            positionCalcConfig.setOldStartDate(positionCalcConfig.getStartDate());
            positionCalcConfig.setOldEndDate(positionCalcConfig.getEndDate());
            positionCalcConfig.setCreateUser("admin");
            positionCalcConfig.setCreateTime(modifyTime);
        }
        super.saveBatch(positionCalcConfigList, 20);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoUpdatePositionCalcConfig() {
        PositionFacadeQueryDTO dto = new PositionFacadeQueryDTO();
        List<PositionFacadeVO> positionList = this.positionIntegration.getAllList(dto);
        if (CollectionUtils.isEmpty(positionList)) {
            log.debug("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5e7f\u544a\u4f4d");
            return;
        }
        Map positionMap = positionList.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        List positionCalcConfigList = super.list();
        if (CollectionUtils.isEmpty((Collection)positionCalcConfigList)) {
            log.debug("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5e7f\u544a\u4f4d\u914d\u7f6e");
            return;
        }
        for (PositionCalcConfig positionCalcConfig : positionCalcConfigList) {
            PositionFacadeVO positionFacadeVO = (PositionFacadeVO)positionMap.get(positionCalcConfig.getPositionId());
            positionCalcConfig.setOldCooperationType(positionCalcConfig.getCooperationType());
            positionCalcConfig.setOldDivideInto(positionCalcConfig.getDivideInto());
            positionCalcConfig.setOldBiddingType(positionCalcConfig.getBiddingType());
            positionCalcConfig.setOldBasePrice(positionCalcConfig.getBasePrice());
            positionCalcConfig.setOldStartDate(positionCalcConfig.getStartDate());
            positionCalcConfig.setOldEndDate(positionCalcConfig.getEndDate());
            positionCalcConfig.setCooperationType(positionFacadeVO.getCooperationType());
            positionCalcConfig.setDivideInto(positionFacadeVO.getDivideInto());
            positionCalcConfig.setBiddingType(positionFacadeVO.getBiddingType());
            positionCalcConfig.setBasePrice(positionFacadeVO.getBasePrice());
            positionCalcConfig.setStartDate(positionFacadeVO.getStartDate());
            positionCalcConfig.setEndDate(positionFacadeVO.getEndDate());
            positionCalcConfig.setModifyUser("admin");
            positionCalcConfig.setModifyTime(new Date());
        }
        super.updateBatchById((Collection)positionCalcConfigList, 20);
    }

    @Override
    public PositionCalcConfig findByPositionId(String positionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"position_id", (Object)positionId);
        return (PositionCalcConfig)this.getOne((Wrapper)queryWrapper);
    }
}

