/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.PositionChannelIncome;
import com.bxm.mccms.common.core.mapper.PositionChannelIncomeMapper;
import com.bxm.mccms.common.core.service.IPositionChannelIncomeService;
import com.bxm.mccms.common.core.service.IPositionIncomeService;
import com.bxm.mccms.common.core.service.impl.BaseServiceImpl;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.StartAndEndTimeUtil;
import com.bxm.mccms.common.model.income.PositionChannelIncomeExcelDTO;
import com.bxm.mccms.common.model.income.PositionChannelIncomeListVO;
import com.bxm.mccms.common.model.income.PositionChannelIncomeQueryDTO;
import com.bxm.mccms.common.model.income.PositionChannelIncomeSyncDTO;
import com.bxm.mccms.common.model.income.PositionChannelIncomeUploadVO;
import com.bxm.mcssp.common.util.DateUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PositionChannelIncomeServiceImpl
extends BaseServiceImpl<PositionChannelIncomeMapper, PositionChannelIncome>
implements IPositionChannelIncomeService {
    @Autowired
    private IPositionIncomeService iPositionIncomeService;

    @Override
    public Page<PositionChannelIncomeListVO> pageBySearch(Page page, PositionChannelIncomeQueryDTO dto) {
        return ((PositionChannelIncomeMapper)this.getBaseMapper()).pageBySearch(page, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PositionChannelIncomeUploadVO upload(UserVo userVo, MultipartFile file) {
        ImportParams importParams = new ImportParams();
        PositionChannelIncomeUploadVO positionChannelIncomeUploadVO = new PositionChannelIncomeUploadVO();
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), PositionChannelIncomeExcelDTO.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            throw new McCmsException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01", new Object[0]);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new McCmsException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff01", new Object[0]);
        }
        this.checkRepeated(list);
        ArrayList<PositionChannelIncome> positionChannelIncomes = new ArrayList<PositionChannelIncome>(list.size());
        HashMap<String, PositionChannelIncome> positionChannelIncomeHashMap = new HashMap<String, PositionChannelIncome>(list.size());
        try {
            for (PositionChannelIncomeExcelDTO positionChannelIncomeExcelDTO : list) {
                PositionChannelIncome positionChannelIncome = new PositionChannelIncome();
                BeanUtils.copyProperties((Object)positionChannelIncomeExcelDTO, (Object)positionChannelIncome);
                positionChannelIncome.setDataId(DateUtil.dateTo8String((Date)positionChannelIncomeExcelDTO.getDatetime()) + positionChannelIncomeExcelDTO.getSdkChannelType() + positionChannelIncomeExcelDTO.getPositionId());
                positionChannelIncome.setCreateUser(userVo.getUsername());
                positionChannelIncome.setCreateTime(new Date());
                BigDecimal divideInto = positionChannelIncomeExcelDTO.getDivideInto();
                BigDecimal zero = new BigDecimal("0");
                BigDecimal hundred = new BigDecimal("1");
                if (divideInto == null || zero.compareTo(divideInto) > 0 || divideInto.compareTo(hundred) > 0) {
                    throw new McCmsException("\u5206\u6210\u6bd4\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u57280-100\u4e4b\u95f4\uff01", new Object[0]);
                }
                positionChannelIncome.setDivideInto(divideInto.multiply(new BigDecimal("100")));
                BigDecimal developerIncome = positionChannelIncome.getTotalIncome().multiply(divideInto).divide(hundred, 2, 4);
                positionChannelIncome.setDeveloperIncome(developerIncome);
                positionChannelIncome.setBxmIncome(positionChannelIncome.getTotalIncome().subtract(developerIncome));
                positionChannelIncomes.add(positionChannelIncome);
                positionChannelIncomeHashMap.put(positionChannelIncome.getDataId(), positionChannelIncome);
            }
        }
        catch (McCmsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new McCmsException("\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u4e0d\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\uff01", new Object[0]);
        }
        QueryWrapper existQueryWrapper = new QueryWrapper();
        existQueryWrapper.in((Object)"data_id", positionChannelIncomeHashMap.keySet());
        List existList = this.list((Wrapper)existQueryWrapper);
        List<String> existPositionIdList = existList.stream().map(PositionChannelIncome::getPositionId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(existPositionIdList)) {
            this.remove((Wrapper)existQueryWrapper);
        }
        this.saveBatch(positionChannelIncomes, 100);
        positionChannelIncomeUploadVO.setAddQuantity(positionChannelIncomes.size() - existList.size());
        positionChannelIncomeUploadVO.setUpdateQuantity(existList.size());
        positionChannelIncomeUploadVO.setUpdatePositionIds(existPositionIdList);
        return positionChannelIncomeUploadVO;
    }

    private void checkRepeated(List<PositionChannelIncomeExcelDTO> list) {
        List repeated = list.stream().filter(t1 -> list.stream().filter(t2 -> t1.getPositionId().equals(t2.getPositionId()) && t1.getDatetime().equals(t2.getDatetime()) && t1.getSdkChannelType().equals(t2.getSdkChannelType())).count() > 1L).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(repeated)) {
            HashSet<String> messageSet = new HashSet<String>();
            for (PositionChannelIncomeExcelDTO dto : repeated) {
                StringBuffer message = new StringBuffer();
                message.append(DateUtil.dateTo8String((Date)dto.getDatetime())).append(dto.getSdkChannelType()).append(dto.getPositionId()).append("\n");
                messageSet.add(message.toString());
            }
            throw new McCmsException("\u6709\u3010" + repeated.size() + "\u3011\u6761\u6570\u636e\u91cd\u590d\uff1a\n" + ((Object)messageSet).toString(), new Object[0]);
        }
    }

    @Override
    public Boolean syncChannelData(UserVo userVo, PositionChannelIncomeSyncDTO positionChannelIncomeSyncDTO) {
        block4: {
            String[] dateArray;
            block3: {
                Map<String, Date> dateTime = StartAndEndTimeUtil.getStartAndEndTime(positionChannelIncomeSyncDTO.getStartTime(), positionChannelIncomeSyncDTO.getEndTime());
                dateArray = StartAndEndTimeUtil.setResultDateTime(dateTime);
                if (dateArray == null || dateArray.length == 0) {
                    throw new McCmsException("\u67e5\u8be2\u7684\u65e5\u671f\u6709\u8bef\u3002", new Object[0]);
                }
                if (!"interact_channel".equals(positionChannelIncomeSyncDTO.getChannel())) break block3;
                for (String dateStr : dateArray) {
                    this.iPositionIncomeService.syncAdsDataToPositionChannelIncome(dateStr, positionChannelIncomeSyncDTO);
                }
                break block4;
            }
            if (!"gdt_channel".equals(positionChannelIncomeSyncDTO.getChannel())) break block4;
            for (String dateStr : dateArray) {
                this.iPositionIncomeService.syncAdnetIncomeDataToPositionChannelIncome(dateStr, positionChannelIncomeSyncDTO);
            }
        }
        return true;
    }
}

