/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.acl.facade.model.UserRo;
import com.bxm.mccms.common.core.entity.PositionDspCreative;
import com.bxm.mccms.common.core.mapper.PositionDspCreativeMapper;
import com.bxm.mccms.common.core.service.IPositionDspCreativeService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.acl.AclUserIntegration;
import com.bxm.mccms.common.model.dsp.PositionDspCreativeDTO;
import com.bxm.mccms.common.model.dsp.PositionDspCreativeVO;
import com.bxm.mccms.common.pushable.CreativePushable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionDspCreativeServiceImpl
extends ServiceImpl<PositionDspCreativeMapper, PositionDspCreative>
implements IPositionDspCreativeService {
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private CreativePushable creativePushable;

    @Override
    public Page<PositionDspCreativeVO> pageByAudit(Page page, PositionDspCreativeDTO query) {
        Page<PositionDspCreativeVO> resp = ((PositionDspCreativeMapper)this.getBaseMapper()).pageByAudit(page, query);
        List list = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resp;
        }
        for (PositionDspCreativeVO vo : list) {
            if (!StringUtils.isNotBlank((CharSequence)vo.getMjCode())) continue;
            UserRo userRo = this.aclUserIntegration.getUserByUsername(vo.getMjCode());
            vo.setMjName(userRo.getName());
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateAuditStatus(PositionDspCreative body) {
        PositionDspCreative t = (PositionDspCreative)this.getById(body.getId());
        if (null == t) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]);
        }
        t.setAuditStatus(body.getAuditStatus());
        if (StringUtils.isNotBlank((CharSequence)body.getRemark())) {
            t.setRemark(body.getRemark());
        }
        t.setAuditTime(new Date());
        ((PositionDspCreativeMapper)this.getBaseMapper()).updateById(t);
        this.creativePushable.push(t);
        return Boolean.TRUE;
    }
}

