/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.PositionDspPos;
import com.bxm.mccms.common.core.mapper.PositionDspPosMapper;
import com.bxm.mccms.common.core.service.IPositionDspPosService;
import com.bxm.mccms.common.helper.enums.DspStaticEnum;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.model.position.PositionDspPosAnalyzeVO;
import com.bxm.mccms.common.model.position.PositionDspPosDTO;
import com.bxm.mccms.common.model.position.PositionDspPosVO;
import com.bxm.mccms.common.pushable.DispatcherPushable;
import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import com.bxm.warcar.utils.DateHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PositionDspPosServiceImpl
extends ServiceImpl<PositionDspPosMapper, PositionDspPos>
implements IPositionDspPosService {
    private static final Logger log = LoggerFactory.getLogger(PositionDspPosServiceImpl.class);
    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private DispatcherPushable dispatcherPushable;
    @Autowired
    private Environment environment;

    @Override
    public Page<PositionDspPosAnalyzeVO> pageByAnalyze(Page page, PositionDspPosDTO query) {
        List orders = page.getOrders();
        boolean isNotExistId = true;
        for (OrderItem order : orders) {
            if (!"id".equals(order.getColumn())) continue;
            isNotExistId = false;
        }
        if (CollectionUtils.isEmpty((Collection)orders) || isNotExistId) {
            orders.add(OrderItem.desc((String)"id"));
        }
        Page<PositionDspPosAnalyzeVO> resp = ((PositionDspPosMapper)this.getBaseMapper()).pageByAnalyze(page, DateHelper.format((String)"yyyy-MM-dd"), query);
        return resp;
    }

    @Override
    public PositionDspPosVO getDetail(Long id) {
        PositionDspPos dspPos = (PositionDspPos)((PositionDspPosMapper)this.getBaseMapper()).selectById(id);
        if (null == dspPos) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]);
        }
        PositionDspPosVO dspPosDTO = new PositionDspPosVO();
        BeanUtils.copyProperties((Object)dspPos, (Object)dspPosDTO);
        return dspPosDTO;
    }

    @Override
    public PositionDspPos getByOnly(String positionId, Long dspId) {
        LambdaQueryWrapper wrapper = new QueryWrapper().lambda();
        wrapper.eq(PositionDspPos::getPositionId, (Object)positionId);
        wrapper.eq(PositionDspPos::getDspId, (Object)dspId);
        List list = ((PositionDspPosMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (PositionDspPos)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean saveInfo(PositionDspPos t) {
        PositionDspPos old = this.getByOnly(t.getPositionId(), t.getDspId());
        if (null != old) {
            throw new McCmsException("\u5e7f\u544a\u5e73\u53f0\u5df2\u7ed1\u5b9a", new Object[0]);
        }
        PositionFacadeVO position = this.positionIntegration.findByPositionId(t.getPositionId());
        PositionSceneTypeEnum positionSceneTypeEnum = PositionSceneTypeEnum.get((Integer)position.getPositionScene());
        if (positionSceneTypeEnum == null) {
            throw new McCmsException("\u5e7f\u544a\u4f4d\u573a\u666f\u7c7b\u578b\u5f02\u5e38", new Object[0]);
        }
        switch (positionSceneTypeEnum) {
            case TAB_PAGE: {
                this.validationDspId(t.getDspId(), positionSceneTypeEnum, DspStaticEnum.SCENE_DSP);
                break;
            }
            case LOCK_SCREEN: {
                this.validationDspId(t.getDspId(), positionSceneTypeEnum, DspStaticEnum.LOCK_SCREET_DSP);
                break;
            }
        }
        t.setOpened(Constants.Opened.OPENED.getType());
        int rows = ((PositionDspPosMapper)this.getBaseMapper()).insert(t);
        this.dispatcherPushable.push((PositionDspPos)this.getById(t.getId()));
        return rows > 0;
    }

    private void validationDspId(Long configDspId, PositionSceneTypeEnum positionSceneTypeEnum, DspStaticEnum dspStaticEnum) {
        Long dspId = null;
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        dspId = activeProfiles.contains("dev") || activeProfiles.contains("test") ? dspStaticEnum.getTestId() : dspStaticEnum.getProId();
        if (!configDspId.equals(dspId)) {
            throw new McCmsException(positionSceneTypeEnum.getDesc() + "\u5e7f\u544a\u4f4d\uff0c\u4ec5\u80fd\u589e\u52a0" + dspStaticEnum.getName(), new Object[0]);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateInfo(PositionDspPos t) {
        PositionDspPos old = this.getByOnly(t.getPositionId(), t.getDspId());
        if (null != old && !Objects.equals(old.getId(), t.getId())) {
            throw new McCmsException("\u5e7f\u544a\u5e73\u53f0\u5df2\u7ed1\u5b9a", new Object[0]);
        }
        t.setDspId(old.getDspId());
        int rows = ((PositionDspPosMapper)this.getBaseMapper()).updateById(t);
        this.dispatcherPushable.push((PositionDspPos)this.getById(t.getId()));
        return rows > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateOpened(Long id, Integer opened) {
        PositionDspPos t = (PositionDspPos)this.getById(id);
        if (null == t) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]);
        }
        t.setOpened(opened);
        ((PositionDspPosMapper)this.getBaseMapper()).updateById(t);
        this.dispatcherPushable.push(t);
        return Boolean.TRUE;
    }

    @Override
    public List<PositionDspPos> getByDspId(List<Long> dspIds) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"dsp_id", dspIds);
        return ((PositionDspPosMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }

    @Override
    public Boolean addDsp(String positionId, DspStaticEnum dspStaticEnum, String dspPosid) {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        Long dspId = activeProfiles.contains("dev") || activeProfiles.contains("test") ? dspStaticEnum.getTestId() : dspStaticEnum.getProId();
        PositionDspPos t = new PositionDspPos();
        t.setPositionId(positionId);
        t.setDspId(dspId);
        t.setDspPosid(dspPosid);
        t.setDspBasePrice(new BigDecimal("0"));
        t.setPriority(1);
        t.setCreateUser("admin");
        t.setCreateTime(new Date());
        t.setPositionId(positionId);
        return this.saveInfo(t);
    }
}

