/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.adsmedia.facade.income.PositionIncomeVO;
import com.bxm.datapark.web.model.SspPositionFinanceDaily;
import com.bxm.mccms.common.core.entity.DeveloperBill;
import com.bxm.mccms.common.core.entity.Dsp;
import com.bxm.mccms.common.core.entity.PositionCalcConfig;
import com.bxm.mccms.common.core.entity.PositionChannelIncome;
import com.bxm.mccms.common.core.entity.PositionDspPos;
import com.bxm.mccms.common.core.entity.PositionIncome;
import com.bxm.mccms.common.core.entity.PositionIncomeLog;
import com.bxm.mccms.common.core.entity.SceneSetting;
import com.bxm.mccms.common.core.mapper.PositionIncomeMapper;
import com.bxm.mccms.common.core.service.IDeveloperBillService;
import com.bxm.mccms.common.core.service.IDeveloperIncomeService;
import com.bxm.mccms.common.core.service.IDspService;
import com.bxm.mccms.common.core.service.IPositionCalcConfigService;
import com.bxm.mccms.common.core.service.IPositionChannelIncomeService;
import com.bxm.mccms.common.core.service.IPositionDspPosService;
import com.bxm.mccms.common.core.service.IPositionIncomeLogService;
import com.bxm.mccms.common.core.service.IPositionIncomeService;
import com.bxm.mccms.common.core.service.ISceneSettingService;
import com.bxm.mccms.common.helper.constant.DatagrabKeyGenerator;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.AdnetUtil;
import com.bxm.mccms.common.helper.util.NumberUtil;
import com.bxm.mccms.common.helper.util.OceanengineUtil;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.adsmedia.PositionIncomeIntegration;
import com.bxm.mccms.common.integration.datapark.DataparkWebIntegration;
import com.bxm.mccms.common.integration.ssp.developer.DeveloperIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionSdkConfigIntegration;
import com.bxm.mccms.common.model.income.PositionChannelIncomeSyncDTO;
import com.bxm.mccms.common.model.income.PositionIncomeDTO;
import com.bxm.mccms.common.model.income.PositionIncomeQueryDTO;
import com.bxm.mccms.common.model.income.datagrab.AdnetIncome;
import com.bxm.mccms.common.model.income.datagrab.AuthenticationInfoCacheVO;
import com.bxm.mccms.common.model.income.datagrab.OceanengineIncome;
import com.bxm.mccms.facade.enums.SceneDspEnum;
import com.bxm.mcssp.common.enums.position.CustomPositionTypeEnum;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.mcssp.common.enums.position.PositionSdkConfigChannelEnum;
import com.bxm.mcssp.common.util.DateUtil;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeQueryDTO;
import com.bxm.mcssp.facade.model.developer.DeveloperFacadeVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeVO;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class PositionIncomeServiceImpl
extends ServiceImpl<PositionIncomeMapper, PositionIncome>
implements IPositionIncomeService {
    private static final Logger log = LoggerFactory.getLogger(PositionIncomeServiceImpl.class);
    @Autowired
    private DataparkWebIntegration dataparkWebIntegration;
    @Autowired
    private IPositionCalcConfigService positionCalcConfigService;
    @Autowired
    private IPositionIncomeLogService positionIncomeLogService;
    @Autowired
    private DeveloperIntegration developerIntegration;
    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private PositionIncomeMapper positionIncomeMapper;
    @Autowired
    private IDeveloperIncomeService developerIncomeService;
    @Autowired
    private IDspService dspService;
    @Autowired
    private IPositionDspPosService positionDspPosService;
    @Autowired
    private PositionSdkConfigIntegration positionSdkConfigIntegration;
    @Autowired
    private JedisFetcher jedisFetcher;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private IDeveloperBillService billService;
    @Resource
    private RestTemplate restTemplate;
    @Autowired
    private ISceneSettingService sceneSettingService;
    @Autowired
    private PositionIncomeIntegration positionIncomeIntegration;
    @Autowired
    private IPositionChannelIncomeService positionChannelIncomeService;
    private static final int DSP_GDT_SDK = 4;
    private static final int DSP_JLYQ_SDK = 5;

    @Override
    public int init() {
        String datetime = LocalDateTimeHelper.formatToString((LocalDateTime)LocalDateTime.now().plusDays(-1L), (String)"yyyy-MM-dd");
        SspPositionFinanceDaily search = new SspPositionFinanceDaily();
        search.setDatetime(datetime);
        List<SspPositionFinanceDaily> positionDspData = this.dataparkWebIntegration.getPositionDspData(search);
        List<PositionFacadeVO> positionFacadeVOList = this.positionIntegration.getAllList(new PositionFacadeQueryDTO());
        Map<String, PositionFacadeVO> positionFacadeVOMap = positionFacadeVOList.stream().collect(Collectors.toMap(PositionFacadeVO::getPositionId, PositionFacadeVO2 -> PositionFacadeVO2, (v1, v2) -> v1));
        this.composite(positionDspData, datetime, positionFacadeVOMap);
        if (CollectionUtils.isEmpty(positionDspData)) {
            log.warn("[{}] Position Data is Empty.", (Object)datetime);
            return -1;
        }
        List list = this.positionCalcConfigService.list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("Position settleType config is Empty.");
            return -1;
        }
        Map<String, PositionCalcConfig> positionCalcConfigMap = list.stream().collect(Collectors.toMap(PositionCalcConfig::getPositionId, PositionCalcConfig2 -> PositionCalcConfig2));
        ArrayList positionIncomeList = Lists.newArrayList();
        positionDspData.forEach(data -> {
            PositionCalcConfig calcConfig = (PositionCalcConfig)positionCalcConfigMap.get(data.getPositionId());
            if (calcConfig == null) {
                log.warn("Position [{}] settleType config is Empty.", (Object)data.getPositionId());
                return;
            }
            PositionIncome positionIncome = this.saveIncome((SspPositionFinanceDaily)data, datetime, calcConfig);
            if (positionFacadeVOMap.get(positionIncome.getPositionId()) == null) {
                log.warn("Position [{}]  is Empty.", (Object)positionIncome.getPositionId());
                return;
            }
            positionIncome.setDockingMethodType(((PositionFacadeVO)positionFacadeVOMap.get(positionIncome.getPositionId())).getDockingMethodType());
            PositionFacadeVO positionFacadeVO = (PositionFacadeVO)positionFacadeVOMap.get(positionIncome.getPositionId());
            positionIncome.setDockingMethodType(positionFacadeVO.getDockingMethodType());
            positionIncome.setPositionScene(positionFacadeVO.getPositionScene());
            positionIncomeList.add(positionIncome);
        });
        this.addSdkPositionIncome(positionFacadeVOList, positionIncomeList, datetime, positionCalcConfigMap);
        this.saveBatch(positionIncomeList);
        return positionIncomeList.size();
    }

    private void addSdkPositionIncome(List<PositionFacadeVO> positionFacadeVOList, List<PositionIncome> positionIncomeList, String datetime, Map<String, PositionCalcConfig> positionCalcConfigMap) {
        for (int i = 0; i < positionFacadeVOList.size(); ++i) {
            PositionFacadeVO position = positionFacadeVOList.get(i);
            PositionIncome csjPositionIncome = new PositionIncome();
            csjPositionIncome.setPositionId(position.getPositionId());
            csjPositionIncome.setAppId(position.getAppId());
            csjPositionIncome.setDatetime(datetime);
            csjPositionIncome.setDeveloperId(position.getDeveloperId());
            csjPositionIncome.setBiddingConsume(PositionIncome.INIT_INCOME);
            csjPositionIncome.setTotalIncome(PositionIncome.INIT_INCOME);
            csjPositionIncome.setDspId(-1L);
            csjPositionIncome.setTotalSend(0L);
            csjPositionIncome.setTotalOpen(0L);
            csjPositionIncome.setTotalClick(0L);
            csjPositionIncome.setUv(0L);
            csjPositionIncome.setDockingMethodType(position.getDockingMethodType());
            csjPositionIncome.setPositionScene(position.getPositionScene());
            csjPositionIncome.setCreateUser("admin");
            csjPositionIncome.setSdkChannelType(PositionSdkConfigChannelEnum.CSJ.getCode());
            PositionCalcConfig calcConfig = positionCalcConfigMap.get(position.getPositionId());
            if (calcConfig != null) {
                this.calculatePositionIncome(datetime, csjPositionIncome, calcConfig);
            }
            PositionIncome gdtPositionIncome = new PositionIncome();
            BeanUtils.copyProperties((Object)csjPositionIncome, (Object)gdtPositionIncome);
            gdtPositionIncome.setSdkChannelType(PositionSdkConfigChannelEnum.GDT.getCode());
            PositionIncome bdPositionIncome = new PositionIncome();
            BeanUtils.copyProperties((Object)csjPositionIncome, (Object)bdPositionIncome);
            bdPositionIncome.setSdkChannelType(PositionSdkConfigChannelEnum.BD.getCode());
            PositionIncome ksPositionIncome = new PositionIncome();
            BeanUtils.copyProperties((Object)csjPositionIncome, (Object)ksPositionIncome);
            ksPositionIncome.setSdkChannelType(PositionSdkConfigChannelEnum.KS.getCode());
            PositionIncome adPositionIncome = new PositionIncome();
            BeanUtils.copyProperties((Object)csjPositionIncome, (Object)adPositionIncome);
            adPositionIncome.setSdkChannelType(PositionSdkConfigChannelEnum.AD.getCode());
            if (PositionSceneTypeEnum.INSPIRE_VIDEO.getType().equals(position.getPositionScene())) {
                PositionIncome ddPositionIncome = new PositionIncome();
                BeanUtils.copyProperties((Object)csjPositionIncome, (Object)ddPositionIncome);
                ddPositionIncome.setSdkChannelType(PositionSdkConfigChannelEnum.BACKUP.getCode());
                positionIncomeList.add(ddPositionIncome);
            }
            positionIncomeList.add(csjPositionIncome);
            positionIncomeList.add(gdtPositionIncome);
            positionIncomeList.add(bdPositionIncome);
            positionIncomeList.add(ksPositionIncome);
            positionIncomeList.add(adPositionIncome);
        }
    }

    private List<SspPositionFinanceDaily> composite(List<SspPositionFinanceDaily> positionDspData, String datetime, Map<String, PositionFacadeVO> positionFacadeVOMap) {
        List positionDspPosList = this.positionDspPosService.list();
        if (CollectionUtils.isEmpty((Collection)positionDspPosList)) {
            log.warn("All PositionDspPos is Empty.");
            return positionDspData;
        }
        HashMap positionDspDataMap = new HashMap(positionDspData.size());
        positionDspData.forEach(data -> positionDspDataMap.put(data.getPositionId() + "-" + data.getDspId(), data));
        positionDspPosList.forEach(position -> {
            PositionFacadeVO positionFacadeVO = (PositionFacadeVO)positionFacadeVOMap.get(position.getPositionId());
            SspPositionFinanceDaily positionFinanceDaily = (SspPositionFinanceDaily)positionDspDataMap.get(position.getPositionId() + "-" + position.getDspId());
            if (positionFacadeVO == null) {
                log.warn("position={} vo is null .", (Object)position.getPositionId());
                return;
            }
            if (positionFacadeVO.getDockingMethodType() == 2 && positionFinanceDaily == null) {
                SspPositionFinanceDaily daily = new SspPositionFinanceDaily();
                daily.setDatetime(datetime);
                daily.setAppId(positionFacadeVO.getAppId());
                daily.setDeveloperId(positionFacadeVO.getDeveloperId());
                daily.setDspId(position.getDspId());
                daily.setPositionId(position.getPositionId());
                positionDspData.add(daily);
            }
        });
        return positionDspData;
    }

    private PositionIncome saveIncome(SspPositionFinanceDaily data, String datetime, PositionCalcConfig calcConfig) {
        PositionIncome income = new PositionIncome();
        income.setPositionId(data.getPositionId());
        income.setAppId(data.getAppId());
        income.setDeveloperId(data.getDeveloperId());
        income.setBiddingConsume(null == data.getBidIncome() ? PositionIncome.INIT_INCOME : data.getBidIncome());
        income.setTotalIncome(income.getBiddingConsume());
        income.setDspId(data.getDspId());
        income.setTotalSend(null == data.getRequestPv() ? 0L : data.getRequestPv().longValue());
        income.setTotalOpen(null == data.getExposurePv() ? 0L : data.getExposurePv().longValue());
        income.setTotalClick(null == data.getClickPv() ? 0L : data.getClickPv().longValue());
        income.setUv(null == data.getRequestUv() ? 0L : data.getRequestUv().longValue());
        income.setCreateUser("admin");
        this.calculatePositionIncome(datetime, income, calcConfig);
        income.setDatetime(datetime);
        income.setStatus(0);
        return income;
    }

    private void calculatePositionIncome(String datetime, PositionIncome income, PositionCalcConfig calcConfig) {
        BigDecimal positionIncome = PositionIncome.INIT_INCOME;
        String settleConfig = "";
        switch (calcConfig.getOldCooperationType()) {
            case 1: {
                positionIncome = NumberUtil.divide(calcConfig.getOldDivideInto(), PositionIncome.DIVIDEINTO_BASE).multiply(income.getTotalIncome()).setScale(2, 3);
                settleConfig = calcConfig.getOldDivideInto().toString() + "%";
                break;
            }
            case 2: {
                if (1 == calcConfig.getOldBiddingType()) {
                    positionIncome = NumberUtil.divide(new BigDecimal(income.getTotalOpen()), PositionIncome.CPM_BASE).multiply(calcConfig.getOldBasePrice()).setScale(2, 3);
                }
                if (2 == calcConfig.getOldBiddingType()) {
                    positionIncome = new BigDecimal(income.getTotalOpen()).multiply(calcConfig.getOldBasePrice()).setScale(2, 3);
                }
                settleConfig = calcConfig.getOldBasePrice().toString();
                break;
            }
            case 3: {
                if (this.compareLocalDate(calcConfig.getOldStartDate(), datetime) > 0 || this.compareLocalDate(calcConfig.getOldEndDate(), datetime) < 0) {
                    log.warn(" [startDate:{}] > [{}] or [endDate:{}] < [{}] .", new Object[]{calcConfig.getOldStartDate(), datetime, calcConfig.getOldEndDate(), datetime});
                    break;
                }
                positionIncome = calcConfig.getOldBasePrice();
                StringBuilder sb = new StringBuilder();
                sb.append(calcConfig.getOldStartDate()).append("-").append(calcConfig.getEndDate()).append(":").append(calcConfig.getBasePrice());
                settleConfig = sb.toString();
                break;
            }
            default: {
                log.warn("Not found this CooperationType [{}].", (Object)calcConfig.getOldCooperationType());
            }
        }
        income.setSettleConfig(settleConfig);
        income.setSettleType(calcConfig.getOldCooperationType());
        income.setPositionPreIncome(positionIncome);
        income.setBxmPreIncome(income.getTotalIncome().subtract(income.getPositionPreIncome()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public Boolean update(PositionIncomeDTO positionIncomeDTO) {
        List<DeveloperFacadeVO> providerAppList;
        UserVo user = UserRoleUtil.getUser();
        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        if (UserRoleUtil.isMj(user)) {
            dto.setMjCode(user.getUsername());
        }
        if (CollectionUtils.isEmpty(providerAppList = this.developerIntegration.list(dto))) {
            log.warn("Developer List is Empty . mj = {}", (Object)dto.getMjCode());
            throw new McCmsException("Developer List is Empty. ", new Object[0]);
        }
        PositionIncome positionIncome = (PositionIncome)this.getById(positionIncomeDTO.getId());
        if (positionIncome == null) {
            throw new McCmsException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5e7f\u544a\u4f4d\u6536\u5165\u8bb0\u5f55\uff0cid = " + positionIncomeDTO.getId(), new Object[0]);
        }
        String month = positionIncome.getDatetime().substring(0, 7);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"month", (Object)month);
        queryWrapper.eq((Object)"developer_id", (Object)positionIncome.getDeveloperId());
        DeveloperBill bill = (DeveloperBill)this.billService.getOne((Wrapper)queryWrapper);
        if (bill != null) {
            throw new McCmsException(month + "\u6708\u8d26\u5355\u5df2\u7ecf\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539 ", new Object[0]);
        }
        if (UserRoleUtil.isMj(user) && 0 != positionIncome.getStatus()) {
            throw new McCmsException("\u8d26\u5355\u4e0d\u662f\u672a\u63d0\u4ea4\u7684\u72b6\u6001\uff0cid = " + positionIncome.getId(), new Object[0]);
        }
        positionIncome.setTotalIncome(positionIncomeDTO.getTotalIncome() == null ? positionIncome.getTotalIncome() : positionIncomeDTO.getTotalIncome());
        positionIncome.setPositionPreIncome(positionIncomeDTO.getPositionPreIncome() == null ? positionIncome.getPositionPreIncome() : positionIncomeDTO.getPositionPreIncome());
        if (positionIncome.getDockingMethodType() == 2) {
            positionIncome.setTotalSend(positionIncomeDTO.getTotalSend() == null ? positionIncome.getTotalSend() : positionIncomeDTO.getTotalSend());
            positionIncome.setTotalOpen(positionIncomeDTO.getTotalOpen() == null ? positionIncome.getTotalOpen() : positionIncomeDTO.getTotalOpen());
            positionIncome.setTotalClick(positionIncomeDTO.getTotalClick() == null ? positionIncome.getTotalClick() : positionIncomeDTO.getTotalClick());
        }
        positionIncome.setModifyUser(user.getUsername());
        positionIncomeDTO.setDatetime(positionIncome.getDatetime());
        positionIncomeDTO.setPositionId(positionIncome.getPositionId());
        positionIncome.setStatus(0);
        this.savePositionIncomeLog(positionIncomeDTO, positionIncome, user.getUsername());
        this.updateById(positionIncome);
        return true;
    }

    private void savePositionIncomeLog(PositionIncomeDTO positionIncomeDTO, PositionIncome positionIncome, String userName) {
        PositionIncomeLog positionIncomeLog = new PositionIncomeLog();
        positionIncomeLog.setPositionIncomeId(positionIncome.getId());
        StringBuilder sb = new StringBuilder();
        sb.append("\u64cd\u4f5c\u4eba:").append(userName);
        if (positionIncomeDTO.getTotalIncome() != null) {
            PositionCalcConfig positionCalcConfig = this.positionCalcConfigService.findByPositionId(positionIncome.getPositionId());
            if (positionCalcConfig == null) {
                log.error("\u5e7f\u544a\u4f4d {},\u6ca1\u6709\u6536\u76ca\u914d\u7f6e\u3002", (Object)positionIncome.getPositionId());
            }
            this.calculatePositionIncome(positionIncome.getDatetime(), positionIncome, positionCalcConfig);
            sb.append(",\u64cd\u4f5c\u5185\u5bb9\uff1a\u4fee\u6539\u5e73\u53f0\u6d88\u8017\u4e3a").append(positionIncome.getTotalIncome());
        }
        if (positionIncomeDTO.getPositionPreIncome() != null) {
            positionIncome.setBxmPreIncome(positionIncome.getTotalIncome().subtract(positionIncome.getPositionPreIncome()));
            sb.append(",\u64cd\u4f5c\u5185\u5bb9\uff1a\u4fee\u6539\u5f00\u53d1\u8005\u9884\u4f30\u6536\u76ca\u4e3a").append(positionIncome.getPositionPreIncome());
        }
        if (positionIncomeDTO.getTotalSend() != null) {
            sb.append(",\u64cd\u4f5c\u5185\u5bb9\uff1a\u4fee\u6539\u603b\u8bf7\u6c42\u4e3a").append(positionIncome.getTotalSend());
        }
        if (positionIncomeDTO.getTotalOpen() != null) {
            sb.append(",\u64cd\u4f5c\u5185\u5bb9\uff1a\u4fee\u6539\u603b\u66dd\u5149\u4e3a").append(positionIncome.getTotalOpen());
        }
        if (positionIncomeDTO.getTotalClick() != null) {
            sb.append(",\u64cd\u4f5c\u5185\u5bb9\uff1a\u4fee\u6539\u603b\u70b9\u51fb\u4e3a").append(positionIncome.getTotalClick());
        }
        sb.append(",\u65f6\u95f4:").append(LocalDateTimeHelper.formatToString((String)"yyyy-MM-dd HH:mm:ss"));
        if (positionIncome.getModifyLogId() != null && positionIncome.getModifyLogId() > 0L) {
            positionIncomeLog.setId(positionIncome.getModifyLogId());
        }
        positionIncomeLog.setRemark(sb.toString());
        this.positionIncomeLogService.saveOrAppend(positionIncomeLog);
        positionIncome.setModifyLogId(positionIncomeLog.getId());
    }

    @Override
    public IPage<com.bxm.mccms.common.model.income.PositionIncomeVO> findAll(UserVo user, PositionIncomeQueryDTO positionIncomeDTO) {
        List<PositionFacadeVO> positionFacadeVOList;
        String mjCode = positionIncomeDTO.getMj();
        if (UserRoleUtil.isMj(user)) {
            if (StringUtils.isNotBlank((CharSequence)mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page();
            }
            mjCode = user.getUsername();
        }
        positionIncomeDTO.setMj(mjCode);
        Page resultPage = new Page();
        IPage page = new Page();
        PositionFacadeQueryDTO dto = new PositionFacadeQueryDTO();
        dto.setPositionId(positionIncomeDTO.getPositionId());
        dto.setMjCode(positionIncomeDTO.getMj());
        dto.setDeveloperKeyword(positionIncomeDTO.getDeveloperKeyword());
        dto.setAppKeyword(positionIncomeDTO.getAppKeyword());
        dto.setPositionKeyword(positionIncomeDTO.getPositionKeyword());
        dto.setPositionScene(positionIncomeDTO.getPositionScene());
        if (dto.getPositionScene() == null) {
            dto.setPositionScenes(PositionSceneTypeEnum.getTypeListByCustomPositionTypeEnum((CustomPositionTypeEnum)CustomPositionTypeEnum.get((Integer)positionIncomeDTO.getCustomPositionType())));
        }
        if (CollectionUtils.isEmpty(positionFacadeVOList = this.positionIntegration.getAllList(dto))) {
            return resultPage;
        }
        if (StringUtils.isBlank((CharSequence)positionIncomeDTO.getPositionId())) {
            log.info("\u5e7f\u544a\u4f4d\u6536\u5165\u6c47\u603b\u6570\u636e");
            List<String> positionIdList = positionFacadeVOList.stream().map(PositionFacadeVO::getPositionId).distinct().collect(Collectors.toList());
            positionIncomeDTO.setPositionIdList(positionIdList);
            page.setCurrent((long)positionIncomeDTO.getCurrent().intValue());
            page.setSize((long)positionIncomeDTO.getSize().intValue());
            page = this.positionIncomeMapper.findPage(page, positionIncomeDTO);
        } else {
            log.info("\u5e7f\u544a\u4f4d\u6536\u5165\u8be6\u60c5");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"position_id", new Object[]{positionIncomeDTO.getPositionId()});
            if (StringUtils.isNotBlank((CharSequence)positionIncomeDTO.getDatetime())) {
                queryWrapper.eq((Object)"datetime", (Object)positionIncomeDTO.getDatetime());
            }
            if (positionIncomeDTO.getSettleType() != null) {
                queryWrapper.eq((Object)"settle_type", (Object)positionIncomeDTO.getSettleType());
            }
            page.setCurrent((long)positionIncomeDTO.getCurrent().intValue());
            page.setSize((long)positionIncomeDTO.getSize().intValue());
            page = this.page(page, (Wrapper)queryWrapper);
        }
        if (page.getRecords().isEmpty()) {
            return resultPage;
        }
        Map<String, PositionFacadeVO> positionFacadeMap = positionFacadeVOList.stream().collect(Collectors.toMap(PositionFacadeVO::getPositionId, PositionFacadeVO2 -> PositionFacadeVO2, (v1, v2) -> v1));
        List dspList = this.dspService.list();
        if (dspList.isEmpty()) {
            log.warn("Dsp is Empty.");
            return resultPage;
        }
        Map<Long, String> dspMap = dspList.stream().collect(Collectors.toMap(Dsp::getId, Dsp::getDspName));
        BeanUtils.copyProperties((Object)page, (Object)resultPage);
        resultPage.setRecords(this.packingResult((IPage<PositionIncome>)page, positionFacadeMap, dspMap));
        return resultPage;
    }

    private List<com.bxm.mccms.common.model.income.PositionIncomeVO> packingResult(IPage<PositionIncome> page, Map<String, PositionFacadeVO> positionFacadeMap, Map<Long, String> dspMap) {
        ArrayList resultList = Lists.newArrayList();
        page.getRecords().forEach(income -> {
            com.bxm.mccms.common.model.income.PositionIncomeVO vo = new com.bxm.mccms.common.model.income.PositionIncomeVO();
            BeanUtils.copyProperties((Object)income, (Object)vo);
            PositionFacadeVO positionFacadeVO = (PositionFacadeVO)positionFacadeMap.get(vo.getPositionId());
            if (positionFacadeVO == null) {
                log.info("[Position:{}] is not found .", (Object)vo.getPositionId());
                return;
            }
            vo.setPositionName(positionFacadeVO.getPositionName());
            vo.setAppName(positionFacadeVO.getAppName());
            vo.setDeveloperName(positionFacadeVO.getDeveloperName());
            vo.setMj(positionFacadeVO.getMjName());
            vo.setDsp((String)dspMap.get(income.getDspId()));
            resultList.add(vo);
        });
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public Boolean publish(PositionIncomeDTO positionIncomeDTO) {
        List<DeveloperFacadeVO> providerAppList;
        UserVo user = UserRoleUtil.getUser();
        DeveloperFacadeQueryDTO dto = new DeveloperFacadeQueryDTO();
        if (UserRoleUtil.isMj(user)) {
            dto.setMjCode(user.getUsername());
        }
        if (CollectionUtils.isEmpty(providerAppList = this.developerIntegration.list(dto))) {
            log.warn("Developer List is Empty . mj = {}", (Object)dto.getMjCode());
            throw new McCmsException("Developer List is Empty. ", new Object[0]);
        }
        int r1 = this.positionIncomeMapper.updateStatusByPositionId(positionIncomeDTO.getPositionId(), 1, user.getUsername(), positionIncomeDTO.getDatetime());
        this.updateDeveloperIncome(providerAppList, user, positionIncomeDTO);
        return r1 > 0;
    }

    private void updateDeveloperIncome(List<DeveloperFacadeVO> providerAppList, UserVo user, PositionIncomeDTO positionIncomeDTO) {
        List<Long> developerIdList = providerAppList.stream().map(DeveloperFacadeVO::getId).collect(Collectors.toList());
        positionIncomeDTO.setDeveloperIdList(developerIdList);
        List<PositionIncome> positionIncomes = this.positionIncomeMapper.findByDeveloperIdList(positionIncomeDTO);
        if (CollectionUtils.isEmpty(positionIncomes)) {
            throw new McCmsException("Position Income is Empty. ", new Object[0]);
        }
        this.developerIncomeService.updateConsume(positionIncomes);
    }

    private int compareLocalDate(LocalDate l1, String datetime) {
        LocalDate now = LocalDate.parse(datetime, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return l1.compareTo(now);
    }

    @Override
    public Boolean syncDatagrabArgs(AuthenticationInfoCacheVO authenticationInfoCacheVO) {
        this.jedisUpdater.update(DatagrabKeyGenerator.getKey(), (Object)authenticationInfoCacheVO);
        return true;
    }

    @Override
    public Boolean syncOceanengineData(String date) {
        AuthenticationInfoCacheVO authenticationInfoCacheVO = (AuthenticationInfoCacheVO)this.jedisFetcher.fetch(DatagrabKeyGenerator.getKey(), AuthenticationInfoCacheVO.class);
        if (StringUtils.isBlank((CharSequence)authenticationInfoCacheVO.getOceanengineCookie()) || StringUtils.isBlank((CharSequence)authenticationInfoCacheVO.getOceanengineXcsrfToken())) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u7a7f\u5c71\u7532\u7684Cookie\u76f8\u5173\u503c\u3002");
            return false;
        }
        String dateTo8String = (String)StringUtils.defaultIfBlank((CharSequence)date, (CharSequence)DateUtil.dateTo8String((Date)DateUtil.getDateBefore((Date)new Date(), (int)1)));
        String cookies = authenticationInfoCacheVO.getOceanengineCookie();
        String XCSRFToken = authenticationInfoCacheVO.getOceanengineXcsrfToken();
        HashMap<String, Object> requestArgs = new HashMap<String, Object>(4);
        requestArgs.put("StartDate", dateTo8String);
        requestArgs.put("EndDate", dateTo8String);
        requestArgs.put("Page", 1);
        requestArgs.put("PageSize", 100);
        List<OceanengineIncome.Entitie> entities = OceanengineUtil.queryAllData(this.restTemplate, cookies, XCSRFToken, requestArgs);
        if (CollectionUtils.isEmpty(entities)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u5e7f\u544a\u4f4d\u6570\u636e\u3002");
            return true;
        }
        System.out.println("\u5171\u67e5\u8be2\u5230 " + entities.size() + " \u6761\u8bb0\u5f55\uff01");
        Map codeIdMap = entities.stream().collect(HashMap::new, (k, v) -> k.put(String.valueOf(v.getCodeId()), v), HashMap::putAll);
        ArrayList channelPositionIds = new ArrayList(codeIdMap.keySet());
        PositionSdkConfigFacadeQueryDTO positionSdkConfigFacadeQueryDTO = new PositionSdkConfigFacadeQueryDTO();
        positionSdkConfigFacadeQueryDTO.setChannelType(PositionSdkConfigChannelEnum.CSJ.getCode());
        positionSdkConfigFacadeQueryDTO.setChannelPositionIds(channelPositionIds);
        List<PositionSdkConfigFacadeVO> positionSdkConfigFacadeVOList = this.positionSdkConfigIntegration.getList(positionSdkConfigFacadeQueryDTO);
        if (CollectionUtils.isEmpty(positionSdkConfigFacadeVOList)) {
            log.warn("Position SDK Config is empty!");
            return true;
        }
        Map positionSdkConfigFacadeVOMap = positionSdkConfigFacadeVOList.stream().collect(HashMap::new, (k, v) -> k.put(v.getChannelPositionId(), v.getPositionId()), HashMap::putAll);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)0);
        queryWrapper.eq((Object)"sdk_channel_type", (Object)PositionSdkConfigChannelEnum.CSJ.getCode());
        queryWrapper.eq((Object)"datetime", (Object)dateTo8String);
        queryWrapper.in((Object)"position_id", positionSdkConfigFacadeVOMap.values());
        List positionIncomeList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)positionIncomeList)) {
            log.warn("[{}] Position income is empty!", (Object)dateTo8String);
            return true;
        }
        Map positionIncomeMap = positionIncomeList.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        ArrayList<PositionIncome> needUpdatePositionList = new ArrayList<PositionIncome>();
        for (Map.Entry stringPositionIncomeEntry : positionSdkConfigFacadeVOMap.entrySet()) {
            OceanengineIncome.Entitie entitie = (OceanengineIncome.Entitie)codeIdMap.get(stringPositionIncomeEntry.getKey());
            if (entitie == null) {
                log.warn((String)stringPositionIncomeEntry.getKey() + "\u6ca1\u6709\u627e\u5230\u5e73\u53f0\u5bf9\u5e94\u7684\u6536\u76ca");
                continue;
            }
            String positionId = (String)stringPositionIncomeEntry.getValue();
            PositionIncome positionIncome = (PositionIncome)positionIncomeMap.get(positionId);
            if (positionIncome == null) {
                log.warn((String)stringPositionIncomeEntry.getKey() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6536\u76ca");
                continue;
            }
            positionIncome.setTotalOpen(Long.valueOf(entitie.getImpression()));
            positionIncome.setTotalClick(Long.valueOf(entitie.getClick()));
            positionIncome.setTotalIncome(new BigDecimal(String.valueOf(entitie.getIncome())));
            needUpdatePositionList.add(positionIncome);
        }
        if (CollectionUtils.isEmpty(needUpdatePositionList)) {
            log.warn("\u6ca1\u6709\u5339\u914d\u7684\u5e7f\u544a\u4f4d\u6536\u76ca\u6570\u636e\u9700\u8981\u66f4\u65b0\uff01");
            return true;
        }
        String userName = "JOB";
        for (PositionIncome positionIncome : needUpdatePositionList) {
            PositionIncomeDTO positionIncomeDTO = new PositionIncomeDTO();
            positionIncomeDTO.setTotalOpen(positionIncome.getTotalOpen());
            positionIncomeDTO.setTotalClick(positionIncome.getTotalClick());
            positionIncomeDTO.setTotalIncome(positionIncome.getTotalIncome());
            positionIncome.setModifyUser(userName);
            positionIncome.setModifyTime(new Date());
            this.savePositionIncomeLog(positionIncomeDTO, positionIncome, userName);
            this.updateById(positionIncome);
        }
        log.warn("\u5171\u66f4\u65b0{}\u6761\u6570\u636e\uff01", (Object)needUpdatePositionList.size());
        return true;
    }

    @Override
    public Boolean syncAdnetData(String date) {
        List<PositionIncome> needUpdatePositionList = this.getAdnetIncomeData(date, true, null);
        if (CollectionUtils.isEmpty(needUpdatePositionList)) {
            log.warn("\u6ca1\u6709\u5339\u914d\u7684\u5e7f\u544a\u4f4d\u6536\u76ca\u6570\u636e\u9700\u8981\u66f4\u65b0\uff01");
            return true;
        }
        String userName = "JOB";
        for (PositionIncome positionIncome : needUpdatePositionList) {
            PositionIncomeDTO positionIncomeDTO = new PositionIncomeDTO();
            positionIncomeDTO.setTotalOpen(positionIncome.getTotalOpen());
            positionIncomeDTO.setTotalClick(positionIncome.getTotalClick());
            positionIncomeDTO.setTotalIncome(positionIncome.getTotalIncome());
            positionIncome.setModifyUser(userName);
            positionIncome.setModifyTime(new Date());
            this.savePositionIncomeLog(positionIncomeDTO, positionIncome, userName);
            this.updateById(positionIncome);
        }
        log.warn("\u5171\u66f4\u65b0{}\u6761\u6570\u636e\uff01", (Object)needUpdatePositionList.size());
        return true;
    }

    @Override
    public Boolean syncAdnetIncomeDataToPositionChannelIncome(String datetime, PositionChannelIncomeSyncDTO positionChannelIncomeSyncDTO) {
        BigDecimal divideInto = new BigDecimal("100");
        List<PositionIncome> positionIncome = this.getAdnetIncomeData(datetime, false, positionChannelIncomeSyncDTO.getPositionId());
        if (CollectionUtils.isEmpty(positionIncome)) {
            throw new McCmsException("\u672a\u627e\u5230\u5e7f\u70b9\u901a\u6e20\u9053\u8be5\u65e5\u671f\u7684\u6570\u636e\u3002", new Object[0]);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sdk_channel_type", (Object)PositionSdkConfigChannelEnum.GDT.getCode());
        queryWrapper.eq((Object)"datetime", (Object)datetime);
        if (StringUtils.isNotBlank((CharSequence)positionChannelIncomeSyncDTO.getPositionId())) {
            queryWrapper.in((Object)"position_id", new Object[]{positionChannelIncomeSyncDTO.getPositionId()});
        }
        List existPositionIncome = this.list((Wrapper)queryWrapper);
        Map existPositionIncomeMap = null;
        if (CollectionUtils.isNotEmpty((Collection)existPositionIncome)) {
            existPositionIncomeMap = existPositionIncome.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        }
        ArrayList<PositionChannelIncome> positionChannelIncomes = new ArrayList<PositionChannelIncome>(50);
        String channel = "\u5e7f\u70b9\u901a";
        for (PositionIncome vo : positionIncome) {
            PositionChannelIncome positionChannelIncome = new PositionChannelIncome();
            positionChannelIncome.setDataId(datetime + channel + vo.getPositionId());
            positionChannelIncome.setPositionId(vo.getPositionId());
            positionChannelIncome.setDatetime(DateUtil.convertStr2Date((String)vo.getDatetime()));
            positionChannelIncome.setSdkChannelType(channel);
            positionChannelIncome.setTotalOpen(vo.getTotalOpen());
            positionChannelIncome.setTotalClick(vo.getTotalClick());
            positionChannelIncome.setTotalIncome(vo.getTotalIncome());
            if (existPositionIncomeMap == null) {
                this.calcIncome(positionChannelIncome, divideInto);
            } else {
                PositionIncome temp = (PositionIncome)existPositionIncomeMap.get(vo.getPositionId());
                if (temp == null) {
                    this.calcIncome(positionChannelIncome, divideInto);
                } else {
                    positionChannelIncome.setDeveloperIncome(temp.getPositionPreIncome());
                    positionChannelIncome.setBxmIncome(vo.getTotalIncome().subtract(temp.getPositionPreIncome()));
                    if (temp.getPositionPreIncome().compareTo(BigDecimal.ZERO) == 0 || temp.getTotalIncome().compareTo(BigDecimal.ZERO) == 0) {
                        positionChannelIncome.setDivideInto(divideInto);
                    } else {
                        BigDecimal divideIntoNew = temp.getPositionPreIncome().divide(vo.getTotalIncome(), 2, 4).multiply(new BigDecimal("100"));
                        positionChannelIncome.setDivideInto(divideIntoNew);
                    }
                }
            }
            positionChannelIncome.setCreateUser("admin");
            positionChannelIncome.setCreateTime(new Date());
            positionChannelIncomes.add(positionChannelIncome);
        }
        if (CollectionUtils.isNotEmpty(positionChannelIncomes)) {
            Set<String> dataIdSet = positionChannelIncomes.stream().map(PositionChannelIncome::getDataId).collect(Collectors.toSet());
            this.checkRepeated(dataIdSet);
            try {
                this.positionChannelIncomeService.saveBatch(positionChannelIncomes);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new McCmsException("\u6570\u636e\u5df2\u7ecf\u5b58\u5728\u3002", new Object[0]);
            }
        }
        return true;
    }

    public List<PositionIncome> getAdnetIncomeData(String date, boolean isPositionIncome, String syncPositionId) {
        AuthenticationInfoCacheVO authenticationInfoCacheVO = (AuthenticationInfoCacheVO)this.jedisFetcher.fetch(DatagrabKeyGenerator.getKey(), AuthenticationInfoCacheVO.class);
        if (StringUtils.isBlank((CharSequence)authenticationInfoCacheVO.getAdnetCookie())) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u5e7f\u70b9\u901a\u7684Cookie\u76f8\u5173\u503c\u3002");
            throw new McCmsException("\u6ca1\u6709\u914d\u7f6e\u5e7f\u70b9\u901a\u7684Cookie\u76f8\u5173\u503c", new Object[0]);
        }
        String dateTo8String = (String)StringUtils.defaultIfBlank((CharSequence)date, (CharSequence)DateUtil.dateTo8String((Date)DateUtil.getDateBefore((Date)new Date(), (int)1)));
        String cookies = authenticationInfoCacheVO.getAdnetCookie();
        HashMap<String, Object> requestArgs = new HashMap<String, Object>(4);
        requestArgs.put("start_date", dateTo8String);
        requestArgs.put("end_date", dateTo8String);
        requestArgs.put("page", 1);
        requestArgs.put("page_size", 100);
        List<AdnetIncome.Entitie> entities = AdnetUtil.queryAllData(this.restTemplate, cookies, requestArgs);
        if (CollectionUtils.isEmpty(entities)) {
            log.warn("\u672a\u67e5\u8be2\u5230\u5e7f\u544a\u4f4d\u6570\u636e\u3002");
            throw new McCmsException("\u672a\u67e5\u8be2\u5230\u5e7f\u544a\u4f4d\u6570\u636e", new Object[0]);
        }
        System.out.println("\u5171\u67e5\u8be2\u5230 " + entities.size() + " \u6761\u8bb0\u5f55\uff01");
        Map codeIdMap = entities.stream().collect(HashMap::new, (k, v) -> k.put(String.valueOf(v.getPlacement_id()), v), HashMap::putAll);
        ArrayList channelPositionIds = new ArrayList(codeIdMap.keySet());
        PositionSdkConfigFacadeQueryDTO positionSdkConfigFacadeQueryDTO = new PositionSdkConfigFacadeQueryDTO();
        positionSdkConfigFacadeQueryDTO.setChannelType(PositionSdkConfigChannelEnum.GDT.getCode());
        positionSdkConfigFacadeQueryDTO.setChannelPositionIds(channelPositionIds);
        positionSdkConfigFacadeQueryDTO.setPositionId(syncPositionId);
        List<PositionSdkConfigFacadeVO> positionSdkConfigFacadeVOList = this.positionSdkConfigIntegration.getList(positionSdkConfigFacadeQueryDTO);
        if (CollectionUtils.isEmpty(positionSdkConfigFacadeVOList)) {
            log.warn("\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u4e3a\u7a7a");
            throw new McCmsException("\u5e7f\u544a\u4f4dSDK\u914d\u7f6e\u4e3a\u7a7a", new Object[0]);
        }
        Map positionSdkConfigFacadeVOMap = positionSdkConfigFacadeVOList.stream().collect(HashMap::new, (k, v) -> k.put(v.getChannelPositionId(), v.getPositionId()), HashMap::putAll);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (isPositionIncome) {
            queryWrapper.eq((Object)"status", (Object)0);
        }
        queryWrapper.eq((Object)"sdk_channel_type", (Object)PositionSdkConfigChannelEnum.GDT.getCode());
        queryWrapper.eq((Object)"datetime", (Object)dateTo8String);
        queryWrapper.in((Object)"position_id", positionSdkConfigFacadeVOMap.values());
        List positionIncomeList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)positionIncomeList)) {
            log.warn("[{}] Position income is empty!", (Object)dateTo8String);
            return Collections.emptyList();
        }
        Map positionIncomeMap = positionIncomeList.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        ArrayList<PositionIncome> needUpdatePositionList = new ArrayList<PositionIncome>();
        for (Map.Entry stringPositionIncomeEntry : positionSdkConfigFacadeVOMap.entrySet()) {
            AdnetIncome.Entitie entitie = (AdnetIncome.Entitie)codeIdMap.get(stringPositionIncomeEntry.getKey());
            if (entitie == null) {
                log.warn((String)stringPositionIncomeEntry.getKey() + "\u6ca1\u6709\u627e\u5230\u5e73\u53f0\u5bf9\u5e94\u7684\u6536\u76ca");
                continue;
            }
            String positionId = (String)stringPositionIncomeEntry.getValue();
            PositionIncome positionIncome = (PositionIncome)positionIncomeMap.get(positionId);
            if (positionIncome == null) {
                log.warn((String)stringPositionIncomeEntry.getKey() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6536\u76ca");
                continue;
            }
            positionIncome.setTotalOpen(Long.valueOf(entitie.getPv()));
            positionIncome.setTotalClick(Long.valueOf(entitie.getClick()));
            positionIncome.setTotalIncome(new BigDecimal(String.valueOf(entitie.getRevenue())));
            needUpdatePositionList.add(positionIncome);
        }
        return needUpdatePositionList;
    }

    @Override
    public Boolean syncAdsData(String datetime) {
        if (StringUtils.isBlank((CharSequence)datetime)) {
            datetime = LocalDateTimeHelper.formatToString((LocalDateTime)LocalDateTime.now().plusDays(-1L), (String)"yyyy-MM-dd");
        }
        HashMap finalDspPositionMaps = Maps.newHashMapWithExpectedSize((int)100);
        List<PositionIncomeVO> positionIncomeVos = this.getInteractIncomeData(finalDspPositionMaps, datetime, true, null);
        for (PositionIncomeVO vo : positionIncomeVos) {
            PositionIncome income = (PositionIncome)finalDspPositionMaps.get(vo.getPositionId());
            PositionIncomeDTO positionIncomeDTO = new PositionIncomeDTO();
            positionIncomeDTO.setTotalIncome(new BigDecimal(vo.getIncome()));
            income.setTotalIncome(positionIncomeDTO.getTotalIncome());
            income.setModifyUser("admin");
            income.setModifyTime(new Date());
            income.setStatus(0);
            this.savePositionIncomeLog(positionIncomeDTO, income, "admin");
            this.updateById(income);
        }
        return true;
    }

    @Override
    public Boolean syncAdsDataToPositionChannelIncome(String datetime, PositionChannelIncomeSyncDTO positionChannelIncomeSyncDTO) {
        BigDecimal divideInto = new BigDecimal("100");
        HashMap finalDspPositionMaps = Maps.newHashMapWithExpectedSize((int)100);
        List<PositionIncomeVO> positionIncomeVos = this.getInteractIncomeData(finalDspPositionMaps, datetime, false, positionChannelIncomeSyncDTO.getPositionId());
        ArrayList<PositionChannelIncome> positionChannelIncomes = new ArrayList<PositionChannelIncome>(50);
        String channel = "\u4e92\u52a8";
        for (PositionIncomeVO vo : positionIncomeVos) {
            PositionIncome income = (PositionIncome)finalDspPositionMaps.get(vo.getPositionId());
            vo.setPositionId(income.getPositionId());
            PositionChannelIncome positionChannelIncome = new PositionChannelIncome();
            positionChannelIncome.setDataId(datetime + channel + vo.getPositionId());
            positionChannelIncome.setPositionId(vo.getPositionId());
            positionChannelIncome.setDatetime(DateUtil.convertStr2Date((String)vo.getDate()));
            positionChannelIncome.setSdkChannelType(channel);
            positionChannelIncome.setTotalOpen(0L);
            positionChannelIncome.setTotalClick(0L);
            positionChannelIncome.setTotalIncome(new BigDecimal(vo.getIncome()));
            this.calcIncome(positionChannelIncome, divideInto);
            positionChannelIncome.setCreateUser("admin");
            positionChannelIncome.setCreateTime(new Date());
            positionChannelIncomes.add(positionChannelIncome);
        }
        if (CollectionUtils.isNotEmpty(positionChannelIncomes)) {
            Set<String> dataIdSet = positionChannelIncomes.stream().map(PositionChannelIncome::getDataId).collect(Collectors.toSet());
            this.checkRepeated(dataIdSet);
            try {
                this.positionChannelIncomeService.saveBatch(positionChannelIncomes);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new McCmsException("\u6570\u636e\u5df2\u7ecf\u5b58\u5728\u3002", new Object[0]);
            }
        }
        return true;
    }

    private void checkRepeated(Set<String> dataIdSet) {
        QueryWrapper existQueryWrapper = new QueryWrapper();
        existQueryWrapper.in((Object)"data_id", dataIdSet);
        List existList = this.positionChannelIncomeService.getBaseMapper().selectList((Wrapper)existQueryWrapper);
        List repeated = existList.stream().map(PositionChannelIncome::getDataId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(repeated)) {
            HashSet<String> messageSet = new HashSet<String>();
            for (String dataId : repeated) {
                StringBuffer message = new StringBuffer();
                message.append(dataId).append("\n");
                messageSet.add(message.toString());
            }
            throw new McCmsException("\u6709\u3010" + repeated.size() + "\u3011\u6761\u6570\u636e\u5df2\u5b58\u5728\uff1a\n" + ((Object)messageSet).toString(), new Object[0]);
        }
    }

    private void calcIncome(PositionChannelIncome positionChannelIncome, BigDecimal divideInto) {
        BigDecimal zero = new BigDecimal("0");
        BigDecimal hundred = new BigDecimal("100");
        if (divideInto == null || zero.compareTo(divideInto) > 0 || divideInto.compareTo(hundred) > 0) {
            throw new McCmsException("\u5206\u6210\u6bd4\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u57280-100\u4e4b\u95f4\uff01", new Object[0]);
        }
        positionChannelIncome.setDivideInto(divideInto);
        BigDecimal developerIncome = positionChannelIncome.getTotalIncome().multiply(divideInto).divide(hundred, 2, 4);
        positionChannelIncome.setDeveloperIncome(developerIncome);
        positionChannelIncome.setBxmIncome(positionChannelIncome.getTotalIncome().subtract(developerIncome));
    }

    private List<PositionIncomeVO> getInteractIncomeData(Map<String, PositionIncome> finalDspPositionMaps, String datetime, boolean isPositionIncome, String syncPositionId) {
        List positionIncomeList;
        if (StringUtils.isNotBlank((CharSequence)syncPositionId)) {
            return this.positionIncomeIntegration.getPositionIncome(Arrays.asList(syncPositionId), datetime);
        }
        List<PositionDspPos> dspPos = this.positionDspPosService.getByDspId(Lists.newArrayList((Object[])new Long[]{14L, 18L}));
        List sencePositions = this.sceneSettingService.getBaseMapper().selectList((Wrapper)new QueryWrapper());
        if (CollectionUtils.isNotEmpty((Collection)sencePositions)) {
            for (Object scene : sencePositions) {
                String sspPositionId;
                if (SceneDspEnum.SceneType.SCENE_TYPE_INTERACT.getType() != ((SceneSetting)scene).getSceneType().intValue() || !StringUtils.isNotBlank((CharSequence)((SceneSetting)scene).getH5Url()) || StringUtils.isBlank((CharSequence)(sspPositionId = PositionIncomeServiceImpl.subPositionId(((SceneSetting)scene).getH5Url())))) continue;
                PositionDspPos pos = new PositionDspPos();
                pos.setDspId(13L);
                pos.setDspPosid(sspPositionId);
                pos.setPositionId(((SceneSetting)scene).getPositionId());
                dspPos.add(pos);
            }
        }
        if (CollectionUtils.isEmpty(dspPos)) {
            log.warn("sync Ads Data is empty \uff01");
            return Collections.emptyList();
        }
        HashMap positionIdDspIdMap = Maps.newHashMapWithExpectedSize((int)dspPos.size());
        for (PositionDspPos pos : dspPos) {
            positionIdDspIdMap.put(pos.getPositionId(), pos);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"datetime", (Object)datetime);
        if (!UserRoleUtil.isLeader(UserRoleUtil.getUser()).booleanValue() && isPositionIncome) {
            queryWrapper.eq((Object)"status", (Object)0);
        }
        if (CollectionUtils.isEmpty((Collection)(positionIncomeList = this.list((Wrapper)queryWrapper)))) {
            log.warn("[{}] Position income is empty!", (Object)datetime);
            return Collections.emptyList();
        }
        ArrayList finalPositions = Lists.newArrayListWithCapacity((int)positionIncomeList.size());
        for (PositionIncome income : positionIncomeList) {
            PositionDspPos pos = (PositionDspPos)positionIdDspIdMap.get(income.getPositionId());
            if (pos == null || !pos.getDspId().equals(income.getDspId())) continue;
            finalPositions.add(pos.getDspPosid());
            finalDspPositionMaps.put(pos.getDspPosid(), income);
        }
        if (MapUtils.isEmpty(finalDspPositionMaps)) {
            log.warn("[{}] Position income is empty!", (Object)datetime);
            return Collections.emptyList();
        }
        List<PositionIncomeVO> positionIncomeVos = this.positionIncomeIntegration.getPositionIncome(finalPositions, datetime);
        return positionIncomeVos;
    }

    private static String subPositionId(String url) {
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return null;
            }
            if (url.contains("appKey") && url.contains("appEntrance")) {
                String appkey = url.substring(url.indexOf("appKey") + 7);
                appkey = appkey.substring(0, appkey.indexOf("&"));
                String appEntrance = url.substring(url.indexOf("appEntrance") + 12);
                appEntrance = appEntrance.substring(0, appEntrance.indexOf("&"));
                return appkey + "-" + appEntrance;
            }
        }
        catch (Exception e) {
            log.error(" \u4ece\u4e92\u52a8url\u4e2d\u83b7\u53d6\u5e7f\u544a\u4f4d\u5931\u8d25{} ", (Object)url);
        }
        return null;
    }

    public static void main(String[] args) throws URISyntaxException, MalformedURLException {
        String url = "https://i.iwanbei.cn/activities?appKey=5e40b051798c4b0d99dc521ec809da04&appEntrance=55554&business=money&i=__IMEI__&f=__IDFA__";
        System.out.println(PositionIncomeServiceImpl.subPositionId(url));
    }
}

