/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.Receipt;
import com.bxm.mccms.common.core.mapper.ReceiptMapper;
import com.bxm.mccms.common.core.service.IReceiptService;
import com.bxm.mccms.common.core.service.impl.BaseServiceImpl;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.model.income.ReceiptExcelDTO;
import com.bxm.mccms.common.model.income.ReceiptQueryDTO;
import com.bxm.mccms.facade.enums.ReceiptStatusEnum;
import com.bxm.mcssp.common.util.DateUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ReceiptServiceImpl
extends BaseServiceImpl<ReceiptMapper, Receipt>
implements IReceiptService {
    @Override
    public Page<Receipt> pageBySearch(Page page, ReceiptQueryDTO dto) {
        return ((ReceiptMapper)this.getBaseMapper()).pageBySearch(page, dto);
    }

    @Override
    public boolean upload(UserVo userVo, MultipartFile file) {
        ImportParams importParams = new ImportParams();
        try {
            List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), ReceiptExcelDTO.class, (ImportParams)importParams);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new McCmsException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff01", new Object[0]);
            }
            ArrayList<Receipt> receipts = new ArrayList<Receipt>(list.size());
            for (ReceiptExcelDTO receiptExcelDTO : list) {
                Receipt receipt = new Receipt();
                BeanUtils.copyProperties((Object)receiptExcelDTO, (Object)receipt);
                receipt.setCreateUser(userVo.getUsername());
                receipt.setCreateTime(new Date());
                receipts.add(receipt);
            }
            this.saveBatch(receipts);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean delete(UserVo userVo, Long id) {
        Receipt receipt = (Receipt)this.findByIdWithNotNull(id);
        ReceiptStatusEnum receiptStatusEnum = ReceiptStatusEnum.get((int)receipt.getStatus());
        if (!ReceiptStatusEnum.UNSETTLED.equals((Object)receiptStatusEnum)) {
            throw new McCmsException("\u53ea\u6709\u672a\u7ed3\u7b97\u72b6\u6001\u7684\u8bb0\u5f55\u53ef\u4ee5\u5220\u9664\uff01", new Object[0]);
        }
        this.removeById(receipt.getId());
        return true;
    }

    @Override
    public boolean updateDetailUrl(UserVo userVo, Receipt dto) {
        if (dto.getId() == null) {
            throw new McCmsException("ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)dto.getIncomeDetailUrl()) && StringUtils.isBlank((CharSequence)dto.getStatementDetailUrl())) {
            throw new McCmsException("\u660e\u7ec6\u5355\u5730\u5740\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01", new Object[0]);
        }
        Receipt receipt = (Receipt)this.findByIdWithNotNull(dto.getId());
        if (StringUtils.isNotBlank((CharSequence)dto.getIncomeDetailUrl()) && StringUtils.isNotBlank((CharSequence)receipt.getIncomeDetailUrl())) {
            throw new McCmsException("\u6536\u76ca\u660e\u7ec6\u5355\u5df2\u4e0a\u4f20\uff0c\u65e0\u6cd5\u91cd\u65b0\u4e0a\u4f20\uff01", new Object[0]);
        }
        receipt.setIncomeDetailUrl(dto.getIncomeDetailUrl());
        if (StringUtils.isNotBlank((CharSequence)dto.getStatementDetailUrl()) && StringUtils.isNotBlank((CharSequence)receipt.getStatementDetailUrl())) {
            throw new McCmsException("\u7ed3\u7b97\u660e\u7ec6\u5355\u5df2\u4e0a\u4f20\uff0c\u65e0\u6cd5\u91cd\u65b0\u4e0a\u4f20\uff01", new Object[0]);
        }
        receipt.setStatementDetailUrl(dto.getStatementDetailUrl());
        receipt.setModifyUser(userVo.getUsername());
        receipt.setModifyTime(new Date());
        this.updateById(receipt);
        return true;
    }

    @Override
    public boolean updateStatementIncome(UserVo userVo, Receipt dto) {
        if (dto.getId() == null) {
            throw new McCmsException("ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", new Object[0]);
        }
        if (dto.getStatementIncome() == null || dto.getStatementIncome().doubleValue() < 0.0) {
            throw new McCmsException("\u7ed3\u7b97\u6536\u76ca\u6570\u636e\u975e\u6cd5\uff01", new Object[0]);
        }
        Receipt receipt = (Receipt)this.findByIdWithNotNull(dto.getId());
        if (ReceiptStatusEnum.UNSETTLED.getValue() != receipt.getStatus().intValue()) {
            throw new McCmsException("\u672a\u7ed3\u7b97\u7684\u8bb0\u5f55\u624d\u80fd\u64cd\u4f5c\uff0c\u8bf7\u786e\u8ba4\uff01", new Object[0]);
        }
        receipt.setStatementIncome(dto.getStatementIncome());
        receipt.setFlowInfo(DateUtil.dateTo8String((Date)new Date()) + "\t" + ReceiptStatusEnum.SETTLED.getName());
        receipt.setStatus(ReceiptStatusEnum.SETTLED.getValue());
        receipt.setModifyUser(userVo.getUsername());
        receipt.setModifyTime(new Date());
        this.updateById(receipt);
        return true;
    }

    @Override
    public boolean updateStatus(UserVo userVo, Receipt dto) {
        if (dto.getId() == null) {
            throw new McCmsException("ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", new Object[0]);
        }
        ReceiptStatusEnum receiptStatusEnum = ReceiptStatusEnum.get((int)dto.getStatus());
        if (receiptStatusEnum == null) {
            throw new McCmsException("\u72b6\u6001\u975e\u6cd5\uff01", new Object[0]);
        }
        Receipt receipt = (Receipt)this.findByIdWithNotNull(dto.getId());
        if (receipt.getStatus() + 1 != dto.getStatus()) {
            throw new McCmsException("\u975e\u6cd5\u7684\u72b6\u6001\u6d41\u8f6c\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u72b6\u6001\uff01", new Object[0]);
        }
        if (ReceiptStatusEnum.UNSETTLED.getValue() == receipt.getStatus().intValue()) {
            throw new McCmsException("\u672a\u7ed3\u7b97\u7684\u8bb0\u5f55\u65e0\u6cd5\u6d41\u8f6c\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u72b6\u6001\uff01", new Object[0]);
        }
        if (ReceiptStatusEnum.COLLECTED.getValue() == receipt.getStatus().intValue()) {
            throw new McCmsException("\u5df2\u6536\u6b3e\u8bb0\u5f55\u65e0\u6cd5\u6d41\u8f6c\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u72b6\u6001\uff01", new Object[0]);
        }
        StringBuffer flowInfo = new StringBuffer(receipt.getFlowInfo());
        flowInfo.append("\n");
        flowInfo.append(DateUtil.dateTo8String((Date)new Date()) + "\t" + receiptStatusEnum.getName());
        receipt.setFlowInfo(flowInfo.toString());
        receipt.setStatus(dto.getStatus());
        receipt.setModifyUser(userVo.getUsername());
        receipt.setModifyTime(new Date());
        this.updateById(receipt);
        return true;
    }
}

