/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.bxm.datapark.web.model.SspActivity;
import com.bxm.datapark.web.model.SspActivityData;
import com.bxm.datapark.web.model.SspActivityDataDTO;
import com.bxm.mccms.common.core.entity.SceneActivity;
import com.bxm.mccms.common.core.mapper.SceneActivityMapper;
import com.bxm.mccms.common.core.service.ISceneActivityService;
import com.bxm.mccms.common.core.service.impl.BaseServiceImpl;
import com.bxm.mccms.common.integration.datapark.DataparkWebIntegration;
import com.bxm.mccms.common.model.position.SceneActivityVO;
import com.bxm.mccms.facade.enums.SceneDspEnum;
import com.bxm.mccms.facade.model.activity.ActivityFacadeDTO;
import com.bxm.mcssp.common.util.DateUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneActivityServiceImpl
extends BaseServiceImpl<SceneActivityMapper, SceneActivity>
implements ISceneActivityService {
    @Autowired
    private DataparkWebIntegration dataparkWebIntegration;

    @Override
    public List<SspActivity> getAllActivityList(SceneDspEnum.SceneType sceneType) {
        SspActivity search = new SspActivity();
        search.setActivityState(null);
        Integer launchControl = search.getLaunchControl();
        if (SceneDspEnum.SceneType.SCENE_TYPE_INSPIRE_VIDEO == sceneType) {
            launchControl = 6;
        } else if (SceneDspEnum.SceneType.SCENE_TYPE_SDK_COMPOUND_ACTIVITY == sceneType) {
            launchControl = 7;
        }
        search.setLaunchControl(launchControl);
        List<SspActivity> activity = ((SceneActivityMapper)this.getBaseMapper()).findActivity(search);
        if (CollectionUtils.isEmpty(activity)) {
            Collections.emptyList();
        }
        return activity;
    }

    @Override
    public List<SceneActivityVO> getList(String positionId, String date) {
        List<SceneActivityVO> sceneActivityVOList = ((SceneActivityMapper)this.getBaseMapper()).list(positionId);
        if (CollectionUtils.isEmpty(sceneActivityVOList)) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)date)) {
            date = DateUtil.dateTo8String((Date)new Date());
        }
        List activityIds = sceneActivityVOList.stream().map(SceneActivity::getActivityId).collect(Collectors.toList());
        SspActivityDataDTO dto = new SspActivityDataDTO();
        dto.setThedate(date);
        dto.setPositionId(positionId);
        dto.setActivityIds(activityIds);
        List<SspActivityData> creativeDataList = this.dataparkWebIntegration.getActivityData(dto);
        if (CollectionUtils.isEmpty(creativeDataList)) {
            return sceneActivityVOList;
        }
        Map activityDataMap = creativeDataList.stream().collect(HashMap::new, (k, v) -> k.put(String.valueOf(v.getActivityId()), v), HashMap::putAll);
        for (SceneActivityVO sceneActivityVO : sceneActivityVOList) {
            SspActivityData sspActivityData = (SspActivityData)activityDataMap.get(sceneActivityVO.getActivityId());
            if (sspActivityData == null) continue;
            sceneActivityVO.setIndexPv(sspActivityData.getIndexPv());
            sceneActivityVO.setIndexUv(sspActivityData.getIndexUv());
            sceneActivityVO.setExposurePv(sspActivityData.getExposurePv());
            sceneActivityVO.setJoinRate(sspActivityData.getJoinRate());
            sceneActivityVO.setUvPlay(sspActivityData.getUvPlay());
        }
        return sceneActivityVOList;
    }

    @Override
    public Integer syncUrl(ActivityFacadeDTO dto) {
        return ((SceneActivityMapper)this.getBaseMapper()).updateUrl(String.valueOf(dto.getActivityId()), dto.getOldActivityUrl(), dto.getNewActivityUrl());
    }
}

