/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.datapark.web.model.SspCreativeDaily;
import com.bxm.mccms.common.core.entity.SceneDspEntranceCreative;
import com.bxm.mccms.common.core.entity.SceneSetting;
import com.bxm.mccms.common.core.entity.SysDict;
import com.bxm.mccms.common.core.mapper.SceneDspEntranceCreativeMapper;
import com.bxm.mccms.common.core.mapper.SceneSettingMapper;
import com.bxm.mccms.common.core.service.ISceneDspEntranceCreativeService;
import com.bxm.mccms.common.core.service.ISceneSettingService;
import com.bxm.mccms.common.core.service.ISysDictService;
import com.bxm.mccms.common.core.service.impl.BaseServiceImpl;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import com.bxm.mccms.common.integration.acl.AclUserIntegration;
import com.bxm.mccms.common.integration.datapark.DataparkWebIntegration;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.model.position.CreativeDTO;
import com.bxm.mccms.common.model.position.CreativeListVO;
import com.bxm.mccms.common.model.position.SceneDspEntranceCreativeQueryDTO;
import com.bxm.mccms.common.model.position.SceneDspEntranceCreativeVO;
import com.bxm.mccms.facade.cache.CreativesKey;
import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.enums.SceneDspEntranceCreativeEnum;
import com.bxm.mccms.facade.enums.SceneDspEnum;
import com.bxm.mccms.facade.model.pushable.SceneSettingCacheVO;
import com.bxm.mcssp.common.exception.BusinessException;
import com.bxm.mcssp.common.util.DateUtil;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

@Service
public class SceneDspEntranceCreativeServiceImpl
extends BaseServiceImpl<SceneDspEntranceCreativeMapper, SceneDspEntranceCreative>
implements ISceneDspEntranceCreativeService {
    @Autowired
    private DataparkWebIntegration dataparkWebIntegration;
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private ISceneSettingService sceneSettingService;
    @Autowired
    private ISysDictService sysDictService;
    @Autowired
    private SceneSettingMapper sceneSettingMapper;
    @Autowired
    private JedisFetcher jedisFetcher;
    @Autowired
    private JedisUpdater jedisUpdater;

    @Override
    public Page<CreativeListVO> pageBySearch(UserVo user, Page page, SceneDspEntranceCreativeQueryDTO dto) {
        dto.setCreativeSource(SceneDspEntranceCreativeEnum.CreativeSource.CREATIVE.getType());
        Page<CreativeListVO> creativeListVOPage = ((SceneDspEntranceCreativeMapper)this.baseMapper).pageBySearch(page, dto);
        List records = creativeListVOPage.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            Map<String, String> uiMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.CMS_UI.getCode(), Boolean.FALSE);
            List<SysDict> sysDictList = this.sysDictService.listAvailable("creative_tag", null);
            Map<String, SysDict> sysDictMap = sysDictList.stream().collect(Collectors.toMap(SysDict::getDictValue, SysDict2 -> SysDict2));
            for (CreativeListVO record : records) {
                record.setCreateUser(uiMap.getOrDefault(record.getCreateUser(), record.getCreateUser()));
                String tags = record.getTags();
                if (!StringUtils.isNotBlank((CharSequence)tags)) continue;
                String[] tagsArray = tags.split(",");
                StringBuffer tagStringBuffer = new StringBuffer();
                for (String tag : tagsArray) {
                    SysDict sysDict = sysDictMap.getOrDefault(tag, new SysDict());
                    SysDict parentDict = sysDictMap.getOrDefault(sysDict.getParentDictValue(), new SysDict());
                    tagStringBuffer.append(parentDict.getDictName());
                    tagStringBuffer.append("-");
                    tagStringBuffer.append(sysDict.getDictName());
                    tagStringBuffer.append(",");
                }
                record.setTags(tagStringBuffer.toString());
            }
        }
        return creativeListVOPage;
    }

    @Override
    public String checkCreativeDbEqualCache() {
        StringBuffer noticeInfo = new StringBuffer();
        QueryWrapper creativeQueryWrapper = new QueryWrapper();
        creativeQueryWrapper.eq((Object)"opened", (Object)Constants.Opened.OPENED.getType());
        List creativeList = super.list((Wrapper)creativeQueryWrapper);
        this.checkCreativeSync(noticeInfo, creativeList);
        this.checkTagAndCreativeSync(noticeInfo, creativeList);
        return noticeInfo.toString();
    }

    private void checkTagAndCreativeSync(StringBuffer noticeInfo, List<SceneDspEntranceCreative> creativeList) {
        List<SysDict> sysDictList = this.sysDictService.listAvailable("creative_tag", null);
        List tagList = sysDictList.stream().filter(p -> !p.getParentDictValue().equals("creative_tag")).collect(Collectors.toList());
        HashMap<String, Integer> tagCreativeNum = new HashMap<String, Integer>(tagList.size());
        HashMap<String, List> tagCreativeMap = new HashMap<String, List>(tagList.size());
        for (SysDict sysDict : tagList) {
            tagCreativeNum.put(sysDict.getDictValue(), 0);
            tagCreativeMap.put(sysDict.getDictValue(), new ArrayList());
        }
        for (SceneDspEntranceCreative sceneDspEntranceCreative : creativeList) {
            String[] tagsArray;
            if (!StringUtils.isNotBlank((CharSequence)sceneDspEntranceCreative.getTags())) continue;
            for (String tag : tagsArray = sceneDspEntranceCreative.getTags().split(",")) {
                if (tagCreativeNum.get(tag) == null) continue;
                tagCreativeNum.put(tag, (Integer)tagCreativeNum.get(tag) + 1);
                List sceneDspEntranceCreatives = (List)tagCreativeMap.get(tag);
                sceneDspEntranceCreatives.add(String.valueOf(sceneDspEntranceCreative.getId()));
                tagCreativeMap.put(tag, sceneDspEntranceCreatives);
            }
        }
        JedisPool jedisPool = (JedisPool)this.jedisUpdater.getClientOriginal();
        for (SysDict sysDict : tagList) {
            String tagName = sysDict.getDictName();
            String tag = sysDict.getDictValue();
            Jedis jedis = jedisPool.getResource();
            Throwable throwable = null;
            try {
                Long tagCreativeCacheNum = jedis.llen(CreativesKey.tagRelationCreative((String)tag).generateKey());
                Integer tagCreativeDbNum = (Integer)tagCreativeNum.get(tag);
                if (tagCreativeDbNum != null && tagCreativeDbNum.intValue() == tagCreativeCacheNum.intValue()) continue;
                noticeInfo.append(tagName).append("\uff1a\u7d20\u6750\u548c\u6807\u7b7e\u5173\u7cfb\u6570\u636e\u5f02\u5e38\uff0c\u5373\u5c06\u540c\u6b65\u6570\u636e\u7f13\u5b58\u3002").append("\r\n");
                Pipeline pipeline = jedis.pipelined();
                pipeline.del(CreativesKey.tagRelationCreative((String)tag).generateKey());
                List creativeIdList = (List)tagCreativeMap.get(tag);
                if (CollectionUtils.isNotEmpty((Collection)creativeIdList)) {
                    String[] nad = creativeIdList.toArray(new String[creativeIdList.size()]);
                    pipeline.lpush(CreativesKey.tagRelationCreative((String)tag).generateKey(), nad);
                }
                pipeline.syncAndReturnAll();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jedis == null) continue;
                if (throwable != null) {
                    try {
                        jedis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jedis.close();
            }
        }
    }

    private void checkCreativeSync(StringBuffer noticeInfo, List<SceneDspEntranceCreative> creativeList) {
        JedisPool jedisPool = (JedisPool)this.jedisUpdater.getClientOriginal();
        Long creativeCacheSize = 0L;
        try (Jedis jedis = jedisPool.getResource();){
            creativeCacheSize = jedis.hlen(CreativesKey.creatives().generateKey());
        }
        int creativeDbSize = creativeList.size();
        if (creativeCacheSize.intValue() != creativeDbSize) {
            noticeInfo.append("\u7d20\u6750\u5e93\u6570\u636e\u5f02\u5e38,\u6570\u636e\u5e93\u6570\u91cf\u6bd4\u7f13\u5b58\u591a:" + (creativeCacheSize.intValue() - creativeDbSize)).append("\r\n");
            try (Jedis jedis = jedisPool.getResource();){
                Pipeline pipeline = jedis.pipelined();
                pipeline.del(CreativesKey.creatives().generateKey());
                for (SceneDspEntranceCreative sceneDspEntranceCreative : creativeList) {
                    SceneSettingCacheVO.MediaEntranceCreative mediaEntranceCreative = new SceneSettingCacheVO.MediaEntranceCreative();
                    BeanUtils.copyProperties((Object)sceneDspEntranceCreative, (Object)mediaEntranceCreative);
                    mediaEntranceCreative.setCreativeId(sceneDspEntranceCreative.getId());
                    pipeline.hset(CreativesKey.creatives().generateKey(), String.valueOf(mediaEntranceCreative.getCreativeId()), JsonHelper.convert((Object)mediaEntranceCreative));
                }
                pipeline.syncAndReturnAll();
            }
        }
    }

    @Override
    public Boolean update(UserVo userVo, SceneDspEntranceCreative creative) {
        JedisPool jedisPool;
        SceneDspEntranceCreative oldCreative = (SceneDspEntranceCreative)this.findByIdWithNotNull(creative.getId());
        Assert.isTrue((SceneDspEntranceCreativeEnum.CreativeSource.CREATIVE.getType() == oldCreative.getCreativeSource().intValue() ? 1 : 0) != 0, (String)"\u8be5\u6587\u4ef6\u5e76\u975e\u7d20\u6750\u5e93\u56fe\u7247\u3002");
        boolean oldOpen = Constants.Opened.OPENED.getType() == oldCreative.getOpened().intValue();
        String oldTags = oldCreative.getTags();
        boolean newOpen = Constants.Opened.OPENED.getType() == creative.getOpened().intValue();
        String newTags = creative.getTags();
        oldCreative.setCreativeName(creative.getCreativeName());
        oldCreative.setOpened(creative.getOpened());
        oldCreative.setTags(creative.getTags());
        oldCreative.setModifyTime(new Date());
        oldCreative.setModifyUser(userVo.getUsername());
        this.updateById(oldCreative);
        ArrayList<Object> oldTagList = new ArrayList();
        ArrayList<Object> newTagList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)oldTags)) {
            oldTagList = new ArrayList<String>(Arrays.asList(oldTags.split(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)newTags)) {
            newTagList = new ArrayList<String>(Arrays.asList(newTags.split(",")));
        }
        String creativeId = String.valueOf(creative.getId());
        if (oldOpen) {
            if (newOpen) {
                if (!oldTags.equals(newTags)) {
                    oldTagList.retainAll(newTagList);
                    ArrayList<String> oldTagListTemp = new ArrayList<String>(Arrays.asList(oldTags.split(",")));
                    oldTagListTemp.removeAll(oldTagList);
                    newTagList.removeAll(oldTagListTemp);
                    JedisPool jedisPool2 = (JedisPool)this.jedisUpdater.getClientOriginal();
                    try (Jedis jedis = jedisPool2.getResource();){
                        Pipeline pipeline = jedis.pipelined();
                        for (String string : oldTagListTemp) {
                            pipeline.lrem(CreativesKey.tagRelationCreative((String)string).generateKey(), 0L, creativeId);
                        }
                        for (String string : newTagList) {
                            pipeline.lpush(CreativesKey.tagRelationCreative((String)string).generateKey(), new String[]{creativeId});
                        }
                        pipeline.syncAndReturnAll();
                    }
                }
            } else {
                List<SceneSetting> sceneSettingList;
                if (CollectionUtils.isNotEmpty(oldTagList)) {
                    jedisPool = (JedisPool)this.jedisUpdater.getClientOriginal();
                    try (Jedis jedis = jedisPool.getResource();){
                        Pipeline pipeline = jedis.pipelined();
                        for (String string : oldTagList) {
                            pipeline.lrem(CreativesKey.tagRelationCreative((String)string).generateKey(), 0L, creativeId);
                        }
                        pipeline.syncAndReturnAll();
                    }
                }
                if (CollectionUtils.isNotEmpty(sceneSettingList = this.sceneSettingMapper.getContainsIdSceneSettingConfig(SceneDspEnum.ScreenType.PERSONALITY_SCREEN.getType(), oldCreative.getId()))) {
                    for (SceneSetting sceneSetting : sceneSettingList) {
                        String screenValue = sceneSetting.getScreenValue();
                        if (StringUtils.isBlank((CharSequence)screenValue)) continue;
                        String[] creativeIds = screenValue.split(",");
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(creativeIds));
                        arrayList.remove(creativeId);
                        String string = StringUtils.join((Object[])arrayList.toArray(), (String)",");
                        sceneSetting.setScreenValue(string);
                    }
                    this.sceneSettingService.updateBatchById(sceneSettingList, 100);
                }
            }
        } else if (newOpen && CollectionUtils.isNotEmpty(newTagList)) {
            jedisPool = (JedisPool)this.jedisUpdater.getClientOriginal();
            try (Jedis jedis = jedisPool.getResource();){
                Pipeline pipeline = jedis.pipelined();
                for (String string : newTagList) {
                    pipeline.lpush(CreativesKey.tagRelationCreative((String)string).generateKey(), new String[]{creativeId});
                }
                pipeline.syncAndReturnAll();
            }
        }
        SceneSettingCacheVO.MediaEntranceCreative mediaEntranceCreative = new SceneSettingCacheVO.MediaEntranceCreative();
        BeanUtils.copyProperties((Object)oldCreative, (Object)mediaEntranceCreative);
        mediaEntranceCreative.setCreativeId(oldCreative.getId());
        this.jedisUpdater.hupdate(CreativesKey.creatives(), creativeId, (Object)JsonHelper.convert((Object)mediaEntranceCreative));
        return Boolean.TRUE;
    }

    @Override
    public Boolean add(UserVo userVo, CreativeDTO creativeDTO) {
        List<CreativeDTO.Creative> addCreatives = creativeDTO.getCreatives();
        Set md5Set = addCreatives.stream().map(CreativeDTO.Creative::getMd5).collect(Collectors.toSet());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"creative_source", (Object)SceneDspEntranceCreativeEnum.CreativeSource.CREATIVE.getType());
        wrapper.in((Object)"md5", md5Set);
        List existList = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            StringBuffer stringBuffer = new StringBuffer("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6587\u4ef6\uff1a");
            for (SceneDspEntranceCreative sceneDspEntranceCreative : existList) {
                stringBuffer.append(sceneDspEntranceCreative.getCreativeName()).append(";");
            }
            throw new BusinessException(stringBuffer.toString());
        }
        ArrayList<SceneDspEntranceCreative> sceneDspEntranceCreatives = new ArrayList<SceneDspEntranceCreative>();
        for (CreativeDTO.Creative creative : addCreatives) {
            SceneDspEntranceCreative sceneDspEntranceCreative = new SceneDspEntranceCreative();
            BeanUtils.copyProperties((Object)creative, (Object)sceneDspEntranceCreative);
            sceneDspEntranceCreative.setId(null);
            sceneDspEntranceCreative.setTags(creativeDTO.getTags());
            sceneDspEntranceCreative.setOpened(Constants.Opened.CLOSED.getType());
            sceneDspEntranceCreative.setCreativeSource(SceneDspEntranceCreativeEnum.CreativeSource.CREATIVE.getType());
            sceneDspEntranceCreative.setCreateTime(new Date());
            sceneDspEntranceCreative.setCreateUser(userVo.getUsername());
            sceneDspEntranceCreatives.add(sceneDspEntranceCreative);
        }
        this.saveBatch(sceneDspEntranceCreatives, 100);
        return Boolean.TRUE;
    }

    @Override
    public List<SceneDspEntranceCreativeVO> getList(String positionId, String date) {
        SceneDspEnum.ScreenType screenType;
        SceneSetting sceneSetting = (SceneSetting)this.sceneSettingService.findOneByOneParam("position_id", positionId);
        if (sceneSetting == null) {
            return Collections.emptyList();
        }
        SceneDspEnum.CreativeSource creativeSource = SceneDspEnum.CreativeSource.get((int)sceneSetting.getCreativeSource());
        if (SceneDspEnum.CreativeSource.MANUAL.equals((Object)creativeSource)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"position_id", (Object)positionId);
            wrapper.eq((Object)"creative_source", (Object)SceneDspEntranceCreativeEnum.CreativeSource.MANUAL.getType());
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Collections.emptyList();
            }
            if (StringUtils.isBlank((CharSequence)date)) {
                date = DateUtil.dateTo8String((Date)new Date());
            }
            ArrayList<SceneDspEntranceCreativeVO> sceneDspEntranceCreativeVOList = new ArrayList<SceneDspEntranceCreativeVO>(list.size());
            for (SceneDspEntranceCreative sceneDspEntranceCreative : list) {
                SceneDspEntranceCreativeVO sceneDspEntranceCreativeVO = new SceneDspEntranceCreativeVO();
                BeanUtils.copyProperties((Object)sceneDspEntranceCreative, (Object)sceneDspEntranceCreativeVO);
                SspCreativeDaily sspCreativeDailyQuery = new SspCreativeDaily();
                sspCreativeDailyQuery.setThedate(date);
                sspCreativeDailyQuery.setCreativeId(String.valueOf(sceneDspEntranceCreative.getId()));
                List<SspCreativeDaily> creativeDataList = this.dataparkWebIntegration.getCreativeData(sspCreativeDailyQuery);
                if (CollectionUtils.isNotEmpty(creativeDataList)) {
                    SspCreativeDaily sspCreativeDaily = creativeDataList.get(0);
                    sceneDspEntranceCreativeVO.setClickPv((long)sspCreativeDaily.getClickPv());
                    sceneDspEntranceCreativeVO.setViewPv((long)sspCreativeDaily.getExposurePv());
                }
                sceneDspEntranceCreativeVOList.add(sceneDspEntranceCreativeVO);
            }
            return sceneDspEntranceCreativeVOList;
        }
        if (SceneDspEnum.CreativeSource.CREATIVE.equals((Object)creativeSource) && SceneDspEnum.ScreenType.PERSONALITY_SCREEN.equals((Object)(screenType = SceneDspEnum.ScreenType.get((int)sceneSetting.getSceneType())))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"creative_source", (Object)SceneDspEntranceCreativeEnum.CreativeSource.CREATIVE.getType());
            wrapper.in((Object)"id", Arrays.asList(sceneSetting.getScreenValue().split(",")));
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Collections.emptyList();
            }
            ArrayList<SceneDspEntranceCreativeVO> sceneDspEntranceCreativeVOList = new ArrayList<SceneDspEntranceCreativeVO>(list.size());
            for (SceneDspEntranceCreative sceneDspEntranceCreative : list) {
                SceneDspEntranceCreativeVO sceneDspEntranceCreativeVO = new SceneDspEntranceCreativeVO();
                BeanUtils.copyProperties((Object)sceneDspEntranceCreative, (Object)sceneDspEntranceCreativeVO);
                sceneDspEntranceCreativeVOList.add(sceneDspEntranceCreativeVO);
            }
            return sceneDspEntranceCreativeVOList;
        }
        return Collections.emptyList();
    }

    @Override
    public Integer getShortlistCreativeCount(UserVo user, String positionId, List<String> tags) {
        PositionFacadeVO positionFacadeVO = this.positionIntegration.findByPositionId(positionId);
        String[] sizeArray = positionFacadeVO.getPositionSize().split("\\*");
        if (sizeArray.length < 2) {
            throw new BusinessException("\u5f53\u524d\u5e7f\u544a\u4f4d\u5c3a\u5bf8\u5f02\u5e38\uff1a" + positionFacadeVO.getPositionSize());
        }
        Integer width = null;
        Integer height = null;
        try {
            width = Integer.valueOf(sizeArray[0]);
            height = Integer.valueOf(sizeArray[1].split("\\s+")[0]);
        }
        catch (Exception e) {
            throw new BusinessException("\u5f53\u524d\u5e7f\u544a\u4f4d\u5c3a\u5bf8\u5f02\u5e38\uff1a" + positionFacadeVO.getPositionSize());
        }
        Page page = new Page(1L, -1L);
        SceneDspEntranceCreativeQueryDTO dto = new SceneDspEntranceCreativeQueryDTO();
        dto.setHeight(height);
        dto.setWidth(width);
        dto.setTags(tags);
        dto.setCreativeSource(SceneDspEntranceCreativeEnum.CreativeSource.CREATIVE.getType());
        dto.setOpened(Constants.Opened.OPENED.getType());
        Page<CreativeListVO> creativeListVOPage = ((SceneDspEntranceCreativeMapper)this.getBaseMapper()).pageBySearch(page, dto);
        return creativeListVOPage.getRecords().size();
    }
}

