/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.SceneActivity;
import com.bxm.mccms.common.core.entity.SceneDspEntranceCreative;
import com.bxm.mccms.common.core.entity.SceneSetting;
import com.bxm.mccms.common.core.mapper.SceneSettingMapper;
import com.bxm.mccms.common.core.service.ISceneActivityService;
import com.bxm.mccms.common.core.service.ISceneDspEntranceCreativeService;
import com.bxm.mccms.common.core.service.ISceneSettingService;
import com.bxm.mccms.common.core.service.impl.BaseServiceImpl;
import com.bxm.mccms.common.helper.enums.RoleEnum;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.helper.util.UserRoleUtil;
import com.bxm.mccms.common.integration.acl.AclUserIntegration;
import com.bxm.mccms.common.model.position.SceneSettingDTO;
import com.bxm.mccms.common.model.position.SceneSettingListVO;
import com.bxm.mccms.common.model.position.SceneSettingQueryDTO;
import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.enums.SceneDspEntranceCreativeEnum;
import com.bxm.mccms.facade.enums.SceneDspEnum;
import com.bxm.mcssp.common.enums.position.CustomPositionTypeEnum;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.mcssp.common.util.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SceneSettingServiceImpl
extends BaseServiceImpl<SceneSettingMapper, SceneSetting>
implements ISceneSettingService {
    @Autowired
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private ISceneDspEntranceCreativeService sceneDspEntranceCreativeService;
    @Autowired
    private ISceneActivityService sceneActivityService;

    @Override
    public Page<SceneSettingListVO> pageBySearch(UserVo user, Page page, SceneSettingQueryDTO dto) {
        String mjCode = dto.getMjCode();
        if (UserRoleUtil.isMj(user)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)mjCode) && !mjCode.equals(user.getUsername())) {
                return new Page();
            }
            mjCode = user.getUsername();
        }
        dto.setMjCode(mjCode);
        ArrayList<Integer> positionScenes = new ArrayList<Integer>();
        if (dto.getPositionScene() != null) {
            positionScenes.add(dto.getPositionScene());
        } else {
            positionScenes.addAll(PositionSceneTypeEnum.getTypeListByCustomPositionTypeEnum((CustomPositionTypeEnum)CustomPositionTypeEnum.get((Integer)dto.getCustomPositionType())));
        }
        dto.setPositionScenes(positionScenes);
        Page<SceneSettingListVO> voPage = ((SceneSettingMapper)this.getBaseMapper()).pageBySearch(page, dto);
        List records = voPage.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            Map<String, String> mjMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.SHANG_YE_HUA_YUN_YING_ZHUAN_YUAN.getCode(), false);
            for (SceneSettingListVO vo : records) {
                vo.setMjName(mjMap.getOrDefault(vo.getMjCode(), ""));
            }
        }
        return voPage;
    }

    @Override
    public Boolean moveSceneActivityToTable() {
        List sceneActivityList = this.sceneActivityService.list();
        if (CollectionUtils.isNotEmpty((Collection)sceneActivityList)) {
            throw new McCmsException("\u6d3b\u52a8\u6570\u636e\u5df2\u7ecf\u8fc1\u79fb\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u8fc1\u79fb\uff01", new Object[0]);
        }
        List sceneSettingList = this.findListByOneParam("scene_type", SceneDspEnum.SceneType.SCENE_TYPE_INSPIRE_VIDEO.getType());
        if (CollectionUtils.isEmpty(sceneSettingList)) {
            return true;
        }
        ArrayList<SceneActivity> sceneActivities = new ArrayList<SceneActivity>(sceneSettingList.size());
        for (SceneSetting sceneSetting : sceneSettingList) {
            SceneActivity sceneActivity = new SceneActivity();
            sceneActivity.setPositionId(sceneSetting.getPositionId());
            sceneActivity.setActivityId(sceneSetting.getActivityId());
            sceneActivity.setActivityUrl(sceneSetting.getActivityUrl());
            sceneActivity.setType(1);
            sceneActivity.setStartDate(DateUtil.StringToDate((String)"2020-01-01"));
            sceneActivity.setEndDate(DateUtil.StringToDate((String)"2099-01-01"));
            sceneActivity.setOpened(1);
            sceneActivity.setCreateUser("admin");
            sceneActivity.setCreateTime(new Date());
            sceneActivities.add(sceneActivity);
        }
        if (CollectionUtils.isNotEmpty(sceneActivities)) {
            this.sceneActivityService.saveBatch(sceneActivities);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean saveConfig(UserVo userVo, SceneSettingDTO dto) {
        String positionId = dto.getPositionId();
        SceneSetting sceneSetting = (SceneSetting)this.findOneByOneParam("position_id", positionId);
        if (dto.getH5Url() != null) {
            dto.setH5Url(dto.getH5Url().trim());
        }
        SceneDspEnum.CreativeSource oldCreativeSource = null;
        if (sceneSetting == null) {
            sceneSetting = new SceneSetting();
            oldCreativeSource = SceneDspEnum.CreativeSource.get((int)dto.getCreativeSource());
            BeanUtils.copyProperties((Object)dto, (Object)sceneSetting);
            super.save((Object)sceneSetting);
        } else {
            oldCreativeSource = SceneDspEnum.CreativeSource.get((int)sceneSetting.getCreativeSource());
            BeanUtils.copyProperties((Object)dto, (Object)sceneSetting);
            super.updateById((Object)sceneSetting);
        }
        this.saveCreative(userVo, oldCreativeSource, sceneSetting, dto, positionId);
        SceneDspEnum.SceneType sceneType = SceneDspEnum.SceneType.get((int)sceneSetting.getSceneType());
        if (SceneDspEnum.SceneType.SCENE_TYPE_INSPIRE_VIDEO == sceneType || SceneDspEnum.SceneType.SCENE_TYPE_SDK_COMPOUND_ACTIVITY == sceneType) {
            this.saveActivitie(userVo, dto, positionId);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"position_id", (Object)positionId);
            this.sceneActivityService.remove((Wrapper)queryWrapper);
        }
        return Boolean.TRUE;
    }

    private void saveActivitie(UserVo userVo, SceneSettingDTO dto, String positionId) {
        SceneActivity sceneActivity;
        this.validatedActivityArgs(dto);
        List<SceneSettingDTO.SceneActivity> sceneActivities = dto.getSceneActivities();
        for (SceneSettingDTO.SceneActivity activity : sceneActivities) {
            activity.setPositionId(positionId);
        }
        List updateObjs = sceneActivities.stream().filter(p -> p.getId() != null).collect(Collectors.toList());
        List addObjs = sceneActivities.stream().filter(p -> p.getId() == null).collect(Collectors.toList());
        List existList = this.sceneActivityService.findListByOneParam("position_id", positionId);
        if (CollectionUtils.isNotEmpty(existList)) {
            List oldIds = existList.stream().map(SceneActivity::getId).collect(Collectors.toList());
            List needUpdateIds = updateObjs.stream().map(SceneSettingDTO.SceneActivity::getId).collect(Collectors.toList());
            oldIds.removeAll(needUpdateIds);
            if (oldIds.size() > 0) {
                this.sceneActivityService.removeByIds(oldIds);
            }
        }
        if (CollectionUtils.isNotEmpty(addObjs)) {
            ArrayList<SceneActivity> needSaveList = new ArrayList<SceneActivity>(addObjs.size());
            for (SceneSettingDTO.SceneActivity addObj : addObjs) {
                sceneActivity = new SceneActivity();
                BeanUtils.copyProperties((Object)addObj, (Object)sceneActivity);
                sceneActivity.setActivityUrl(sceneActivity.getActivityUrl() + StringUtils.defaultIfBlank((String)sceneActivity.getDiyArgs(), (String)""));
                sceneActivity.setCreateUser(userVo.getUsername());
                sceneActivity.setCreateTime(new Date());
                needSaveList.add(sceneActivity);
            }
            this.sceneActivityService.saveBatch(needSaveList);
        }
        if (CollectionUtils.isNotEmpty(updateObjs)) {
            ArrayList<SceneActivity> needUpdateList = new ArrayList<SceneActivity>(updateObjs.size());
            for (SceneSettingDTO.SceneActivity updateObj : updateObjs) {
                sceneActivity = new SceneActivity();
                sceneActivity.setId(updateObj.getId());
                sceneActivity.setRateOfFlow(updateObj.getRateOfFlow());
                sceneActivity.setPositionConfig(updateObj.getPositionConfig());
                sceneActivity.setOpened(updateObj.getOpened());
                sceneActivity.setModifyUser(userVo.getUsername());
                sceneActivity.setModifyTime(new Date());
                needUpdateList.add(sceneActivity);
            }
            this.sceneActivityService.updateBatchById(needUpdateList);
        }
    }

    private void validatedActivityArgs(SceneSettingDTO dto) {
        List<SceneSettingDTO.SceneActivity> launchActivityList;
        List openedSceneActivityList = dto.getSceneActivities().stream().filter(p -> Constants.Opened.OPENED.getType() == p.getOpened().intValue()).collect(Collectors.toList());
        if (openedSceneActivityList.size() < 1) {
            throw new McCmsException("\u6d3b\u52a8\u81f3\u5c11\u8981\u5f00\u542f\u4e00\u4e2a\uff01", new Object[0]);
        }
        List<SceneSettingDTO.SceneActivity> testActivityList = openedSceneActivityList.stream().filter(p -> 2 == p.getType()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(testActivityList) && testActivityList.size() > 1) {
            this.validatedActivityDateOverlap(testActivityList);
            for (SceneSettingDTO.SceneActivity sceneActivity : testActivityList) {
                if (sceneActivity.getRateOfFlow() == null || sceneActivity.getRateOfFlow() >= 0 && sceneActivity.getRateOfFlow() <= 100) continue;
                throw new McCmsException("\u6d41\u91cf\u5360\u6bd4\u53ea\u80fd\u57280-100\u4e4b\u95f4\u3002", new Object[0]);
            }
        }
        if (CollectionUtils.isNotEmpty(launchActivityList = openedSceneActivityList.stream().filter(p -> 1 == p.getType()).collect(Collectors.toList())) && launchActivityList.size() > 1) {
            this.validatedActivityDateOverlap(launchActivityList);
        }
    }

    private void validatedActivityDateOverlap(List<SceneSettingDTO.SceneActivity> openedSceneActivityList) {
        ArrayList<String> dateList = new ArrayList<String>();
        String split = "#";
        for (SceneSettingDTO.SceneActivity sceneActivity : openedSceneActivityList) {
            dateList.add(DateUtil.dateTo8String((Date)sceneActivity.getStartDate()) + split + DateUtil.dateTo8String((Date)sceneActivity.getEndDate()));
        }
        List<String> errorList = com.bxm.mccms.common.helper.util.DateUtil.validatedDateOverlap(dateList, split);
        if (CollectionUtils.isNotEmpty(errorList)) {
            throw new McCmsException(errorList.toString(), new Object[0]);
        }
    }

    private void saveCreative(UserVo userVo, SceneDspEnum.CreativeSource oldCreativeSource, SceneSetting sceneSetting, SceneSettingDTO dto, String positionId) {
        SceneDspEnum.CreativeSource newCreativeSource = SceneDspEnum.CreativeSource.get((int)dto.getCreativeSource());
        if (sceneSetting == null) {
            if (SceneDspEnum.CreativeSource.MANUAL.equals((Object)newCreativeSource)) {
                this.saveManualCreative(userVo, dto, positionId);
            }
        } else if (!oldCreativeSource.equals((Object)newCreativeSource)) {
            if (SceneDspEnum.CreativeSource.MANUAL.equals((Object)newCreativeSource)) {
                this.saveManualCreative(userVo, dto, positionId);
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"position_id", (Object)positionId);
                queryWrapper.eq((Object)"creative_source", (Object)SceneDspEntranceCreativeEnum.CreativeSource.MANUAL.getType());
                this.sceneDspEntranceCreativeService.remove((Wrapper)queryWrapper);
            }
        } else if (oldCreativeSource.equals((Object)newCreativeSource) && SceneDspEnum.CreativeSource.MANUAL.equals((Object)newCreativeSource)) {
            this.saveManualCreative(userVo, dto, positionId);
        }
    }

    private void saveManualCreative(UserVo userVo, SceneSettingDTO dto, String positionId) {
        SceneDspEntranceCreative sceneDspEntranceCreative;
        List<SceneSettingDTO.MediaEntranceCreative> mediaEntranceCreatives = dto.getMediaEntranceCreatives();
        for (SceneSettingDTO.MediaEntranceCreative mediaEntranceCreative : mediaEntranceCreatives) {
            mediaEntranceCreative.setPositionId(positionId);
        }
        List updateObjs = mediaEntranceCreatives.stream().filter(p -> p.getId() != null).collect(Collectors.toList());
        List addObjs = mediaEntranceCreatives.stream().filter(p -> p.getId() == null).collect(Collectors.toList());
        QueryWrapper sceneDspEntranceCreativeQueryWrapper = new QueryWrapper();
        sceneDspEntranceCreativeQueryWrapper.eq((Object)"position_id", (Object)positionId);
        sceneDspEntranceCreativeQueryWrapper.eq((Object)"creative_source", (Object)SceneDspEntranceCreativeEnum.CreativeSource.MANUAL.getType());
        List existList = this.sceneDspEntranceCreativeService.list((Wrapper)sceneDspEntranceCreativeQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            List oldIds = existList.stream().map(SceneDspEntranceCreative::getId).collect(Collectors.toList());
            List needUpdateIds = updateObjs.stream().map(SceneSettingDTO.MediaEntranceCreative::getId).collect(Collectors.toList());
            oldIds.removeAll(needUpdateIds);
            if (oldIds.size() > 0) {
                this.sceneDspEntranceCreativeService.removeByIds(oldIds);
            }
        }
        if (CollectionUtils.isNotEmpty(addObjs)) {
            ArrayList<SceneDspEntranceCreative> needSaveList = new ArrayList<SceneDspEntranceCreative>(addObjs.size());
            for (SceneSettingDTO.MediaEntranceCreative addObj : addObjs) {
                sceneDspEntranceCreative = new SceneDspEntranceCreative();
                BeanUtils.copyProperties((Object)addObj, (Object)sceneDspEntranceCreative);
                sceneDspEntranceCreative.setCreativeSource(SceneDspEntranceCreativeEnum.CreativeSource.MANUAL.getType());
                sceneDspEntranceCreative.setCreateUser(userVo.getUsername());
                sceneDspEntranceCreative.setCreateTime(new Date());
                needSaveList.add(sceneDspEntranceCreative);
            }
            this.sceneDspEntranceCreativeService.saveBatch(needSaveList);
        }
        if (CollectionUtils.isNotEmpty(updateObjs)) {
            ArrayList<SceneDspEntranceCreative> needUpdateList = new ArrayList<SceneDspEntranceCreative>(updateObjs.size());
            for (SceneSettingDTO.MediaEntranceCreative addObj : updateObjs) {
                sceneDspEntranceCreative = new SceneDspEntranceCreative();
                BeanUtils.copyProperties((Object)addObj, (Object)sceneDspEntranceCreative);
                sceneDspEntranceCreative.setCreativeSource(SceneDspEntranceCreativeEnum.CreativeSource.MANUAL.getType());
                sceneDspEntranceCreative.setModifyUser(userVo.getUsername());
                sceneDspEntranceCreative.setModifyTime(new Date());
                needUpdateList.add(sceneDspEntranceCreative);
            }
            this.sceneDspEntranceCreativeService.updateBatchById(needUpdateList);
        }
    }
}

