/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.PositionShieldStrategyRef;
import com.bxm.mccms.common.core.entity.ShieldStrategy;
import com.bxm.mccms.common.core.mapper.ShieldStrategyMapper;
import com.bxm.mccms.common.core.service.IPositionShieldStrategyRefService;
import com.bxm.mccms.common.core.service.IShieldStrategyService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.ssp.position.PositionIntegration;
import com.bxm.mccms.common.model.position.PositionRefShieldStrategyVO;
import com.bxm.mccms.common.model.position.ShieldStrategyRelationPositionVO;
import com.bxm.mccms.common.pushable.ShieldStrategyPushable;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.model.position.PositionFacadeDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.PositionFacadeVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShieldStrategyServiceImpl
extends ServiceImpl<ShieldStrategyMapper, ShieldStrategy>
implements IShieldStrategyService {
    @Autowired
    private IPositionShieldStrategyRefService positionShieldStrategyRefService;
    @Autowired
    private PositionIntegration positionIntegration;
    @Autowired
    private ShieldStrategyPushable shieldStrategyPushable;

    @Override
    public List<IDAndNameVO> getIdAndNameList(List<Long> ids) {
        return ((ShieldStrategyMapper)this.baseMapper).getIdAndNameList(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean save(ShieldStrategy t) {
        int rows = ((ShieldStrategyMapper)this.getBaseMapper()).insert(t);
        this.shieldStrategyPushable.push((ShieldStrategy)this.getById(t.getId()));
        return rows > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(ShieldStrategy t) {
        ShieldStrategy old = (ShieldStrategy)this.getById(t.getId());
        if (null == old) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728", new Object[0]);
        }
        int rows = ((ShieldStrategyMapper)this.getBaseMapper()).updateById(t);
        this.shieldStrategyPushable.push((ShieldStrategy)this.getById(t.getId()));
        return rows > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(Serializable id) {
        boolean result = super.removeById(id);
        if (result) {
            QueryWrapper positionShieldStrategyRefWrapper = new QueryWrapper();
            positionShieldStrategyRefWrapper.eq((Object)"shield_strategy_id", (Object)id);
            this.positionShieldStrategyRefService.remove((Wrapper)positionShieldStrategyRefWrapper);
            this.shieldStrategyPushable.delete(id);
        }
        return result;
    }

    @Override
    public IPage<ShieldStrategyRelationPositionVO> getRelationPosition(Page page, Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"shield_strategy_id", (Object)id);
        IPage refPage = this.positionShieldStrategyRefService.page((IPage)page, (Wrapper)queryWrapper);
        List refPageRecords = refPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)refPageRecords)) {
            return new Page();
        }
        List positionIdList = refPageRecords.stream().map(n -> n.getPositionId()).distinct().collect(Collectors.toList());
        PositionFacadeQueryDTO query = new PositionFacadeQueryDTO();
        query.setPositionIds(positionIdList);
        query.setCurrent(page.getCurrent());
        query.setSize(page.getSize());
        IPage<PositionFacadeVO> positionPage = this.positionIntegration.page(query);
        List positionList = positionPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)positionList)) {
            return new Page();
        }
        Map positionMap = positionList.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        ArrayList<ShieldStrategyRelationPositionVO> resultList = new ArrayList<ShieldStrategyRelationPositionVO>(refPageRecords.size());
        for (PositionShieldStrategyRef ref : refPageRecords) {
            ShieldStrategyRelationPositionVO vo = new ShieldStrategyRelationPositionVO();
            resultList.add(vo);
            vo.setId(ref.getId());
            PositionFacadeVO positionFacadeVO = (PositionFacadeVO)positionMap.get(ref.getPositionId());
            if (positionFacadeVO == null) continue;
            vo.setPositionName(positionFacadeVO.getPositionName());
            vo.setAppName(positionFacadeVO.getAppName());
        }
        page.setRecords(resultList);
        return page;
    }

    @Override
    public List<PositionRefShieldStrategyVO> getRefShieldStrategy(String positionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"position_id", (Object)positionId);
        List refPageRecords = this.positionShieldStrategyRefService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)refPageRecords)) {
            return Collections.emptyList();
        }
        List shieldStrategyIdList = refPageRecords.stream().map(n -> n.getShieldStrategyId()).distinct().collect(Collectors.toList());
        List shieldStrategyList = ((ShieldStrategyMapper)this.baseMapper).selectBatchIds(shieldStrategyIdList);
        if (CollectionUtils.isEmpty((Collection)shieldStrategyList)) {
            return Collections.emptyList();
        }
        Map shieldStrategyMap = shieldStrategyList.stream().collect(HashMap::new, (k, v) -> k.put(v.getId(), v), HashMap::putAll);
        ArrayList<PositionRefShieldStrategyVO> resultList = new ArrayList<PositionRefShieldStrategyVO>(refPageRecords.size());
        for (PositionShieldStrategyRef ref : refPageRecords) {
            PositionRefShieldStrategyVO vo = new PositionRefShieldStrategyVO();
            resultList.add(vo);
            vo.setId(ref.getId());
            ShieldStrategy shieldStrategy = (ShieldStrategy)shieldStrategyMap.get(ref.getShieldStrategyId());
            if (shieldStrategy == null) continue;
            vo.setStrategyName(shieldStrategy.getStrategyName());
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeRelationPositionById(Long id) {
        String positionId;
        PositionFacadeVO positionFacadeVO;
        boolean result;
        PositionShieldStrategyRef positionShieldStrategyRef = (PositionShieldStrategyRef)this.positionShieldStrategyRefService.getById(id);
        if (null != positionShieldStrategyRef && (result = this.positionShieldStrategyRefService.removeById(id)) && null != (positionFacadeVO = this.positionIntegration.findByPositionId(positionId = positionShieldStrategyRef.getPositionId()))) {
            PositionFacadeDTO dto = new PositionFacadeDTO();
            BeanUtils.copyProperties((Object)positionFacadeVO, (Object)dto);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"position_id", (Object)positionId);
            List refPageRecords = this.positionShieldStrategyRefService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)refPageRecords)) {
                dto.setShieldStrategyIds("");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                for (PositionShieldStrategyRef refPageRecord : refPageRecords) {
                    stringBuffer.append(refPageRecord.getShieldStrategyId()).append(",");
                }
                dto.setShieldStrategyIds(stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString());
            }
            this.positionIntegration.update(dto);
        }
        return Boolean.TRUE;
    }
}

