/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.adx.facade.model.task.TaskCounter;
import com.bxm.mccms.common.core.entity.Task;
import com.bxm.mccms.common.core.entity.TaskRules;
import com.bxm.mccms.common.core.mapper.TaskMapper;
import com.bxm.mccms.common.core.service.ITaskRulesService;
import com.bxm.mccms.common.core.service.ITaskService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.integration.adx.TaskIntegration;
import com.bxm.mccms.common.model.task.TaskDTO;
import com.bxm.mccms.common.model.task.TaskDetailVO;
import com.bxm.mccms.common.model.task.TaskListVO;
import com.bxm.mccms.common.model.task.TaskQueryDTO;
import com.bxm.mccms.common.pushable.TaskPushable;
import com.bxm.mccms.facade.enums.RuleTypeEnum;
import com.bxm.mccms.facade.enums.TaskPauseReasonEnum;
import com.bxm.mccms.facade.enums.TaskStatusEnum;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskServiceImpl
extends ServiceImpl<TaskMapper, Task>
implements ITaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    private ITaskRulesService taskRulesService;
    @Autowired
    private TaskPushable taskPushable;
    @Autowired
    private TaskIntegration taskIntegration;

    @Override
    public Page<TaskListVO> page(Page page, TaskQueryDTO query) {
        List taskIdList;
        String taskIdStr;
        List<TaskCounter> taskCounterList;
        Page<TaskListVO> voPage = ((TaskMapper)this.getBaseMapper()).page(page, query);
        List records = voPage.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)records) && CollectionUtils.isNotEmpty(taskCounterList = this.taskIntegration.list(taskIdStr = StringUtils.join((Object[])(taskIdList = records.stream().map(TaskListVO::getId).collect(Collectors.toList())).toArray(), (String)",")))) {
            Map<Long, TaskCounter> positionCalcConfigMap = taskCounterList.stream().collect(Collectors.toMap(TaskCounter::getId, TaskCounter2 -> TaskCounter2));
            for (TaskListVO task : records) {
                TaskCounter taskCounter = positionCalcConfigMap.get(task.getId());
                if (taskCounter == null) continue;
                task.setTodayAcquires(taskCounter.getTodayAcquires());
                task.setTodayClicks(taskCounter.getTodayClicks());
                task.setTodayViews(taskCounter.getTodayViews());
                task.setTodayReadyWakes(taskCounter.getTodayReadyWakes());
                task.setTodayWakes(taskCounter.getTodayWakes());
                task.setTodaySuccessWakes(taskCounter.getTodaySucceedWakes());
            }
        }
        return voPage;
    }

    @Override
    public TaskDetailVO get(Long id) {
        Task task = (Task)super.getById((Serializable)id);
        if (task == null) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728\uff01", new Object[0]);
        }
        TaskDetailVO vo = new TaskDetailVO();
        BeanUtils.copyProperties((Object)task, (Object)vo);
        QueryWrapper taskQueryWrapper = new QueryWrapper();
        taskQueryWrapper.eq((Object)"task_id", (Object)task.getId());
        List taskRules = this.taskRulesService.list((Wrapper)taskQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)taskRules)) {
            for (TaskRules taskRule : taskRules) {
                RuleTypeEnum ruleTypeEnum = RuleTypeEnum.get((int)taskRule.getRuleType());
                if (ruleTypeEnum == null) continue;
                switch (ruleTypeEnum) {
                    case REGION: {
                        vo.setRegion(taskRule.getRuleValue());
                        break;
                    }
                    case POSITION: {
                        vo.setPosition(taskRule.getRuleValue());
                        break;
                    }
                    case FREQUENCYS: {
                        vo.setFrequencys(taskRule.getRuleValue());
                        break;
                    }
                    case APP: {
                        vo.setApps(taskRule.getRuleValue());
                        break;
                    }
                    case DEVICE_BRAND: {
                        vo.setDeviceBrands(taskRule.getRuleValue());
                        break;
                    }
                    case TIME_SLOT: {
                        vo.setTimeSlots(taskRule.getRuleValue());
                        break;
                    }
                }
            }
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Task add(TaskDTO dto) {
        super.save((Object)dto);
        this.saveTaskRule(dto);
        return dto;
    }

    private void saveTaskRule(TaskDTO dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getRegion())) {
            this.taskRulesService.save(dto.getId(), RuleTypeEnum.REGION, dto.getRegion());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPosition())) {
            this.taskRulesService.save(dto.getId(), RuleTypeEnum.POSITION, dto.getPosition());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getFrequencys())) {
            this.taskRulesService.save(dto.getId(), RuleTypeEnum.FREQUENCYS, dto.getFrequencys());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getApps())) {
            this.taskRulesService.save(dto.getId(), RuleTypeEnum.APP, dto.getApps());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDeviceBrands())) {
            this.taskRulesService.save(dto.getId(), RuleTypeEnum.DEVICE_BRAND, dto.getDeviceBrands());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTimeSlots())) {
            this.taskRulesService.save(dto.getId(), RuleTypeEnum.TIME_SLOT, dto.getTimeSlots());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean update(TaskDTO dto) {
        Task task = (Task)super.getById((Serializable)dto.getId());
        if (task == null) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728\uff01", new Object[0]);
        }
        dto.setStatus(task.getStatus());
        dto.setPauseReason(task.getPauseReason());
        super.updateById((Object)dto);
        QueryWrapper taskQueryWrapper = new QueryWrapper();
        taskQueryWrapper.eq((Object)"task_id", (Object)dto.getId());
        this.taskRulesService.remove((Wrapper)taskQueryWrapper);
        this.saveTaskRule(dto);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updatePriority(TaskDTO dto) {
        Task task = (Task)super.getById((Serializable)dto.getId());
        if (task == null) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728\uff01", new Object[0]);
        }
        if (!TaskStatusEnum.PAUSE.equals((Object)TaskStatusEnum.get((int)task.getStatus()))) {
            throw new McCmsException("\u53ea\u6709\u6682\u505c\u72b6\u6001\u4e0b\u7684\u4efb\u52a1\u624d\u80fd\u4fee\u6539\uff01", new Object[0]);
        }
        task.setPriority(dto.getPriority());
        super.updateById((Object)task);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateStatus(TaskDTO dto) {
        Task task = (Task)super.getById((Serializable)dto.getId());
        if (task == null) {
            throw new McCmsException("\u6570\u636e\u4e0d\u5b58\u5728\uff01", new Object[0]);
        }
        if (TaskStatusEnum.STOP.equals((Object)TaskStatusEnum.get((int)task.getStatus()))) {
            throw new McCmsException("\u505c\u6b62\u72b6\u6001\u4e0b\u7684\u4efb\u52a1\u65e0\u6cd5\u4fee\u6539\uff01", new Object[0]);
        }
        if (TaskStatusEnum.RUNING.equals((Object)TaskStatusEnum.get((int)dto.getStatus()))) {
            QueryWrapper taskQueryWrapper = new QueryWrapper();
            taskQueryWrapper.ne((Object)"id", (Object)task.getId());
            taskQueryWrapper.eq((Object)"status", (Object)TaskStatusEnum.RUNING.getValue());
            taskQueryWrapper.eq((Object)"priority", (Object)task.getPriority());
            List list = super.list((Wrapper)taskQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                throw new McCmsException("\u5df2\u5b58\u5728\u4f18\u5148\u7ea7\u4e3a " + task.getPriority() + " \u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u5f00\u542f\uff01", new Object[0]);
            }
            task.setPauseReason(null);
        } else {
            task.setPauseReason(TaskPauseReasonEnum.MANUAL.getValue());
        }
        task.setStatus(dto.getStatus());
        super.updateById((Object)task);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean autoUpdateTaskStatus() {
        return Boolean.TRUE;
    }
}

