/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.mccms.common.core.entity.TaskTemplate;
import com.bxm.mccms.common.core.mapper.TaskTemplateMapper;
import com.bxm.mccms.common.core.service.ITaskTemplateService;
import com.bxm.mccms.common.helper.exception.McCmsException;
import com.bxm.mccms.common.model.task.TaskTemplateDTO;
import com.bxm.mccms.common.model.task.TaskTemplateJsonVO;
import com.bxm.mccms.common.model.task.TaskTemplateListVO;
import com.bxm.mccms.common.model.task.TaskTemplateQueryDTO;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TaskTemplateServiceImpl
extends ServiceImpl<TaskTemplateMapper, TaskTemplate>
implements ITaskTemplateService {
    @Override
    public List<TaskTemplateListVO> listByUser(String userName) {
        TaskTemplateQueryDTO queryDTO = new TaskTemplateQueryDTO();
        queryDTO.setCreateUser(userName);
        return ((TaskTemplateMapper)this.getBaseMapper()).list(queryDTO);
    }

    @Override
    public TaskTemplateJsonVO getTemplateByUser(Long id, String userName) {
        TaskTemplate template = (TaskTemplate)((TaskTemplateMapper)this.getBaseMapper()).selectById(id);
        if (null == template) {
            throw new McCmsException("\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", new Object[0]);
        }
        if (!Objects.equals(template.getCreateUser(), userName)) {
            throw new McCmsException("\u975e\u672c\u4eba\u6a21\u677f", new Object[0]);
        }
        if (StringUtils.isEmpty((String)template.getTemplateContent())) {
            return null;
        }
        return (TaskTemplateJsonVO)JSON.parseObject((String)template.getTemplateContent(), TaskTemplateJsonVO.class);
    }

    @Override
    public TaskTemplate add(TaskTemplateDTO dto) {
        if (StringUtils.isEmpty((String)dto.getTemplateName())) {
            throw new McCmsException("\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        if (null == dto.getJson()) {
            throw new McCmsException("\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        dto.setTemplateContent(JSON.toJSONString((Object)dto.getJson()));
        ((TaskTemplateMapper)this.getBaseMapper()).insert(dto);
        return dto;
    }

    @Override
    public Boolean deleteByUser(Long id, String userName) {
        TaskTemplate template = (TaskTemplate)((TaskTemplateMapper)this.getBaseMapper()).selectById(id);
        if (null == template) {
            throw new McCmsException("\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", new Object[0]);
        }
        if (!Objects.equals(template.getCreateUser(), userName)) {
            throw new McCmsException("\u975e\u672c\u4eba\u6a21\u677f", new Object[0]);
        }
        return ((TaskTemplateMapper)this.getBaseMapper()).deleteById(id) > 0;
    }
}

