/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.mccms.common.helper.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.mccms.common.integration.assembly.ResultModel;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AssemblyUtil {
    private static HttpHeaders HEADERS = new HttpHeaders();

    public static ResponseEntity<String> getList(RestTemplate restTemplate, String apiUrl, String adId, String pname, Integer pageNum, Integer pageSize) {
        Object responseEntity = null;
        StringBuilder url = new StringBuilder(apiUrl);
        url.append("/component/getList?1=1");
        if (null == pageNum) {
            url.append("&pageNum=").append(1);
        } else {
            url.append("&pageNum=").append(pageNum);
        }
        if (null == pageSize) {
            url.append("&pageSize=").append(30);
        } else {
            url.append("&pageSize=").append(pageSize);
        }
        if (StringUtils.isNotBlank((CharSequence)adId)) {
            url.append("&adId=").append(adId);
        }
        if (StringUtils.isNotBlank((CharSequence)pname)) {
            url.append("&pname=").append(pname);
        }
        return restTemplate.getForEntity(url.toString(), String.class, new Object[0]);
    }

    public static ResponseEntity<String> getDetail(RestTemplate restTemplate, String apiUrl, String adId, Integer pid) {
        Object responseEntity = null;
        StringBuilder url = new StringBuilder(apiUrl);
        url.append("/component/getDetail?1=1");
        if (StringUtils.isNotBlank((CharSequence)adId)) {
            url.append("&adId=").append(adId);
        }
        if (null != pid) {
            url.append("&pid=").append(pid);
        }
        return restTemplate.getForEntity(url.toString(), String.class, new Object[0]);
    }

    public static ResponseEntity<String> bind(RestTemplate restTemplate, String apiUrl, String adId, List<Integer> pids) {
        Object responseEntity = null;
        StringBuilder url = new StringBuilder(apiUrl);
        url.append("/component/bind");
        HashMap<String, String> request = new HashMap<String, String>(2);
        request.put("adId", adId);
        request.put("pids", StringUtils.join(pids, (String)","));
        HttpEntity entity = new HttpEntity(request, (MultiValueMap)HEADERS);
        return restTemplate.postForEntity(url.toString(), (Object)entity, String.class, new Object[0]);
    }

    public static void main(String[] args) {
        String apiUrl = "http://mcmsapi-test.venomlipstick.cn";
        RestTemplate restTemplate = AssemblyUtil.restTemplate();
        ResponseEntity<String> responseEntity = AssemblyUtil.bind(restTemplate, apiUrl, "test", Arrays.asList(9));
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            ResultModel response = (ResultModel)JSON.parseObject((String)((String)responseEntity.getBody()), (TypeReference)new TypeReference<ResultModel<Boolean>>(){}, (Feature[])new Feature[0]);
            System.out.println(JsonHelper.convert((Object)response));
        } else {
            System.out.println("nonono");
        }
    }

    private static RestTemplate restTemplate() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(30);
        connectionManager.setDefaultMaxPerRoute(30);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(500).setConnectTimeout(500).setConnectionRequestTimeout(500).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        return new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient));
    }

    static {
        HEADERS.setContentType(MediaType.APPLICATION_JSON);
    }
}

